/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record Argv(List<String> argv) {
    public Argv {
        Argv.requireNonEmpty(argv);
        argv = List.copyOf((Collection)Objects.requireNonNull(argv));
    }

    private static void requireNonEmpty(Collection<?> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least on item expected.");
        }
    }

    public static Argv of(List<String> argv) {
        return new Argv(argv);
    }

    public static Argv of(String ... argv) {
        return new Argv(List.of(argv));
    }

    public static Argv ofArgs(String command, String ... args) {
        return Argv.ofArgs(command, List.of(args));
    }

    public static Argv ofArgs(String command, List<String> args) {
        ArrayList<String> argv = new ArrayList<String>(1 + args.size());
        argv.add(command);
        argv.addAll(args);
        return new Argv(argv);
    }

    public boolean isEmpty() {
        return this.argv.isEmpty();
    }

    public String command() {
        return this.argv.isEmpty() ? null : this.argv.get(0);
    }

    public List<String> args() {
        return this.argv.subList(1, this.argv.size());
    }

    public String[] toArray() {
        return (String[])this.argv.toArray(String[]::new);
    }

    public String[] argsToArray() {
        return (String[])this.args().toArray(String[]::new);
    }
}

