package org.aksw.shellgebra.exec.stage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;

import org.aksw.shellgebra.util.PathLifeCycle;
import org.aksw.shellgebra.util.PathLifeCycles;

/**
 * A no-op file writer task that just serves an existing file.
 */
public class FileWriterTaskNoop
    extends FileWriterTaskBase
{
    public FileWriterTaskNoop(Path path) {
        super(path, PathLifeCycles.none());
    }

    public FileWriterTaskNoop(Path path, PathLifeCycle pathLifeCycle) {
        super(path, pathLifeCycle);
    }

    @Override
    public void start() {
        checkIfAbortHasBeenCalled();
        checkIfNew();
        state.set(TaskState.TERMINATED);
    }

    @Override
    public void abort() {
        state.compareAndSet(TaskState.NEW, TaskState.TERMINATED);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected void prepareWriteFile() throws IOException {
    }

    @Override
    protected void runWriteFile() throws IOException {
    }

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public void waitForCompletion() throws ExecutionException, InterruptedException {
    }

    @Override
    public String toString() {
        return "(noOpWriter " + getOutputPath() + ")";
    }
}
