/*
 * Decompiled with CFR 0.152.
 */
package to_delete;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import to_delete.ImageEntry;
import to_delete.ToolEntry;

public class DockerToolRegistry {
    protected Map<String, ToolEntry> primaryEntry;
    protected Table<String, String, ImageEntry> toolTable = HashBasedTable.create();

    public DockerToolRegistry declarePrimary(String toolName, String imageName, String command) {
        this.primaryEntry.put(toolName, new ToolEntry(toolName, imageName, command));
        return this;
    }

    public DockerToolRegistry declarePresence(String programName, String imageName, String command) {
        this.toolTable.row((Object)programName).computeIfAbsent(imageName, in -> new ImageEntry(programName, (String)in)).declarePresence(command);
        return this;
    }

    public DockerToolRegistry declareAbsence(String programName, String imageName, String command) {
        this.toolTable.row((Object)programName).computeIfAbsent(imageName, in -> new ImageEntry(programName, (String)in)).declareAbsence(command);
        return this;
    }
}

