/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderBase;

public class ProcessBuilderNative
extends ProcessBuilderBase<ProcessBuilderNative> {
    public static ProcessBuilderNative of(String ... command) {
        return (ProcessBuilderNative)new ProcessBuilderNative().command(command);
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(this.command());
        pb.environment().putAll(this.environment());
        if (this.directory() != null) {
            pb.directory(this.directory().toFile());
        }
        pb = ProcessBuilderNative.configure(pb, this, executor);
        return pb.start();
    }

    private static void configureInput(JRedirect redirect, Path fd, boolean fdOverridesInherit, Consumer<ProcessBuilder.Redirect> redirectConsumer) {
        block7: {
            block6: {
                if (!(redirect instanceof JRedirect.JRedirectJava)) break block6;
                JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
                ProcessBuilder.Redirect r = x.redirect();
                ProcessBuilder.Redirect.Type type = r.type();
                switch (type) {
                    case PIPE: {
                        redirectConsumer.accept(ProcessBuilder.Redirect.from(fd.toFile()));
                        break;
                    }
                    case READ: {
                        redirectConsumer.accept(ProcessBuilder.Redirect.from(r.file()));
                        break;
                    }
                    case INHERIT: {
                        if (fdOverridesInherit) {
                            redirectConsumer.accept(ProcessBuilder.Redirect.from(fd.toFile()));
                            break;
                        }
                        break block7;
                    }
                    default: {
                        throw new RuntimeException("unsupported or not implemented");
                    }
                }
                break block7;
            }
            throw new RuntimeException("unsupported or not implemented");
        }
    }

    private static void configureOutput(JRedirect redirect, Path fd, boolean fdOverridesInherit, Consumer<ProcessBuilder.Redirect> redirectConsumer) {
        if (redirect instanceof JRedirect.JRedirectJava) {
            JRedirect.JRedirectJava x = (JRedirect.JRedirectJava)redirect;
            ProcessBuilder.Redirect r = x.redirect();
            ProcessBuilder.Redirect.Type type = r.type();
            switch (type) {
                case PIPE: {
                    redirectConsumer.accept(ProcessBuilder.Redirect.to(fd.toFile()));
                    break;
                }
                case WRITE: {
                    redirectConsumer.accept(ProcessBuilder.Redirect.to(r.file()));
                    break;
                }
                case INHERIT: {
                    if (!fdOverridesInherit) break;
                    redirectConsumer.accept(ProcessBuilder.Redirect.to(fd.toFile()));
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported or not implemented");
                }
            }
        }
    }

    public static ProcessBuilder configure(ProcessBuilder tgt, IProcessBuilderCore<?> src, ProcessRunner cxt) {
        boolean inheritInFromSystem = true;
        boolean inheritOutFromSystem = true;
        boolean inheritErrFromSystem = true;
        ProcessBuilderNative.configureInput(src.redirectInput(), cxt.inputPipe(), inheritInFromSystem, tgt::redirectInput);
        ProcessBuilderNative.configureOutput(src.redirectOutput(), cxt.outputPipe(), inheritOutFromSystem, tgt::redirectOutput);
        ProcessBuilderNative.configureOutput(src.redirectError(), cxt.errorPipe(), inheritErrFromSystem, tgt::redirectError);
        return tgt;
    }

    @Override
    protected ProcessBuilderNative cloneActual() {
        return new ProcessBuilderNative();
    }

    @Override
    public boolean supportsAnonPipeRead() {
        return true;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        return true;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        return true;
    }

    @Override
    public boolean accessesStdIn() {
        return true;
    }
}

