/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aksw.shellgebra.algebra.cmd.op.placed.PlacedCmdOp;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderCore;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.ExecSiteResolver;
import org.aksw.vshell.registry.ExecSiteToProcessDispatcher;
import org.aksw.vshell.registry.FinalPlacement;

public class ProcessBuilderFinalPlacement
extends ProcessBuilderCore<ProcessBuilderFinalPlacement> {
    private FileMapper fileMapper;
    private ExecSiteResolver resolver;
    private CommandCatalog commandCatalog;
    private FinalPlacement placement;

    public ProcessBuilderFinalPlacement(FileMapper fileMapper, ExecSiteResolver resolver, CommandCatalog commandCatalog) {
        this.fileMapper = Objects.requireNonNull(fileMapper);
        this.resolver = Objects.requireNonNull(resolver);
        this.commandCatalog = Objects.requireNonNull(commandCatalog);
    }

    public ProcessBuilderFinalPlacement command(FinalPlacement placement) {
        this.placement = placement;
        return (ProcessBuilderFinalPlacement)this.self();
    }

    public FinalPlacement command() {
        return this.placement;
    }

    public FileMapper fileMapper() {
        return this.fileMapper;
    }

    public ProcessBuilderFinalPlacement fileMapper(FileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return (ProcessBuilderFinalPlacement)this.self();
    }

    public ExecSiteResolver execSiteResolver() {
        return this.resolver;
    }

    public ProcessBuilderFinalPlacement execSiteResolver(ExecSiteResolver resolver) {
        this.resolver = resolver;
        return (ProcessBuilderFinalPlacement)this.self();
    }

    @Override
    protected ProcessBuilderFinalPlacement cloneActual() {
        return new ProcessBuilderFinalPlacement(this.fileMapper, this.resolver, this.commandCatalog);
    }

    protected void applySettings(ProcessBuilderFinalPlacement target) {
        target.command(this.command());
        super.applySettings(target);
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        IProcessBuilderCore<?> processBuilder = this.toProcessBuilder(this.placement, executor);
        Process result = processBuilder.start(executor);
        return result;
    }

    public ExecSiteToProcessDispatcher newDispatcher(ProcessRunner context) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ExecSiteToProcessDispatcher dispatcher = new ExecSiteToProcessDispatcher(this.placement, context, this.commandCatalog, this.fileMapper, executorService);
        return dispatcher;
    }

    public IProcessBuilderCore<?> toProcessBuilder(FinalPlacement placement, ProcessRunner context) {
        ExecSiteToProcessDispatcher dispatcher = this.newDispatcher(context);
        PlacedCmdOp.PlacedCmd root = placement.cmdOp();
        IProcessBuilderCore<?> result = dispatcher.resolve(root);
        return result;
    }

    @Override
    public boolean supportsAnonPipeRead() {
        return true;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        return true;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        return true;
    }

    @Override
    public boolean accessesStdIn() {
        return true;
    }
}

