/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOps;
import org.aksw.shellgebra.algebra.cmd.op.placed.PlacedCmdOp;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.vshell.registry.FinalPlacement;

public class FinalPlacementInliner {
    public static FinalPlacement inline(FinalPlacement inPlacement) {
        PlacedCmdOp.PlacedCmd root = inPlacement.cmdOp();
        Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap = inPlacement.placements();
        FinalPlacementInlinerWorker worker = new FinalPlacementInlinerWorker(inMap);
        CmdOp cmdOp = root.cmdOp();
        ExecSite execSite = root.execSite();
        PlacedCmdOp.PlacedCmd tmp = worker.place(cmdOp, execSite);
        Map<CmdOpVar, PlacedCmdOp.PlacedCmd> outMap = worker.getOutMap();
        return new FinalPlacement(tmp, outMap);
    }

    static class FinalPlacementInlinerWorker {
        private Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap;
        private Map<CmdOpVar, PlacedCmdOp.PlacedCmd> outMap = new HashMap<CmdOpVar, PlacedCmdOp.PlacedCmd>();

        public FinalPlacementInlinerWorker(Map<CmdOpVar, PlacedCmdOp.PlacedCmd> inMap) {
            this.inMap = inMap;
        }

        public Map<CmdOpVar, PlacedCmdOp.PlacedCmd> getOutMap() {
            return this.outMap;
        }

        public PlacedCmdOp.PlacedCmd place(CmdOp inParentOp, ExecSite parentSite) {
            Set<CmdOpVar> parentVars = CmdOps.accVars(inParentOp);
            CmdOp outParentOp = inParentOp;
            HashMap<CmdOpVar, CmdOp> substMap = new HashMap<CmdOpVar, CmdOp>();
            for (CmdOpVar v : parentVars) {
                PlacedCmdOp.PlacedCmd inChild = this.inMap.get(v);
                CmdOp inChildCmdOp = inChild.cmdOp();
                ExecSite inChildExecSite = inChild.execSite();
                PlacedCmdOp.PlacedCmd outChild = this.place(inChildCmdOp, inChildExecSite);
                CmdOp outChildOp = outChild.cmdOp();
                ExecSite outChildExecSite = outChild.execSite();
                if (outChildExecSite.equals(parentSite)) {
                    substMap.put(v, outChildOp);
                    continue;
                }
                PlacedCmdOp.PlacedCmd childPlacement = this.place(outChildOp, outChildExecSite);
                this.outMap.put(v, childPlacement);
            }
            if (!substMap.isEmpty()) {
                outParentOp = CmdOps.subst(outParentOp, substMap::get);
            }
            return new PlacedCmdOp.PlacedCmd(outParentOp, parentSite);
        }
    }
}

