/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.time.Instant;
import java.util.Optional;
import org.aksw.commons.util.docker.Argv;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.vshell.registry.Availability;

public class ExecSiteProbeResults {
    public static ExecSiteProbeResults INSTANCE = null;
    private Table<String, ExecSite, Availability> toolToExecSite = HashBasedTable.create();
    private Table<Argv, ExecSite, Availability> argvToExecSite = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecSiteProbeResults get() {
        if (INSTANCE != null) return INSTANCE;
        Class<ExecSiteProbeResults> clazz = ExecSiteProbeResults.class;
        synchronized (ExecSiteProbeResults.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ExecSiteProbeResults();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public ExecSiteProbeResults put(String command, ExecSite execSite, boolean isPresent) {
        Availability availability = new Availability(isPresent, null, Instant.now());
        this.toolToExecSite.put((Object)command, (Object)execSite, (Object)availability);
        return this;
    }

    public Boolean get(String command, ExecSite execSite) {
        Availability availability = (Availability)this.toolToExecSite.get((Object)command, (Object)execSite);
        return availability == null ? null : Boolean.valueOf(availability.available());
    }

    public ExecSiteProbeResults put(Argv argv, ExecSite execSite, boolean isPresent) {
        Availability availability = new Availability(isPresent, null, Instant.now());
        this.argvToExecSite.put((Object)argv, (Object)execSite, (Object)availability);
        return this;
    }

    public Optional<Availability> get(Argv argv, ExecSite execSite) {
        Availability availability = (Availability)this.toolToExecSite.get((Object)argv, (Object)execSite);
        return Optional.ofNullable(availability);
    }

    public boolean isKnownUnavailable(Argv argv, ExecSite execSite) {
        Optional<Availability> value = this.get(argv, execSite);
        boolean result = value.map(Availability::available).orElse(true) == false;
        return result;
    }
}

