/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.aksw.shellgebra.io.pipe.PosixPipe;
import org.aksw.vshell.registry.DynamicOutput;
import org.aksw.vshell.registry.OutputBase;
import org.apache.commons.io.output.ProxyOutputStream;

public class DynamicOutputFromStream
extends OutputBase
implements DynamicOutput {
    protected OutputStream coreOutput;
    protected PosixPipe pipe = null;
    protected CompletableFuture<?> pumpFuture = null;
    protected Object lock = new Object();

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new DynamicOutputStream(this.coreOutput);
    }

    protected DynamicOutputFromStream(OutputStream coreOutput) {
        super(null);
        this.coreOutput = coreOutput;
    }

    public static DynamicOutputFromStream of(OutputStream coreOutput) {
        return new DynamicOutputFromStream(coreOutput);
    }

    @Override
    public boolean hasFile() {
        return this.pipe != null;
    }

    @Override
    public Path getFile() throws IOException {
        this.upgrade();
        return this.pipe.getWriteEndProcPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade() throws IOException {
        if (this.pipe == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pipe == null) {
                    this.pipe = PosixPipe.open();
                    ((DynamicOutputStream)((Object)this.outputStream())).setDelegate(this.pipe.getOutputStream());
                    Runnable runnable = () -> {
                        try (InputStream in = this.pipe.getInputStream();){
                            in.transferTo(this.coreOutput);
                            this.coreOutput.flush();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    };
                    this.pumpFuture = CompletableFuture.runAsync(runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.pipe != null) {
                this.pipe.getOutputStream().close();
            }
        }
        finally {
            try {
                if (this.pumpFuture != null) {
                    this.pumpFuture.join();
                }
            }
            finally {
                try {
                    if (this.pipe != null) {
                        this.pipe.close();
                    }
                }
                finally {
                    this.coreOutput.close();
                }
            }
        }
    }

    private static class DynamicOutputStream
    extends ProxyOutputStream {
        public DynamicOutputStream(OutputStream proxy) {
            super(proxy);
        }

        public void setDelegate(OutputStream proxy) {
            this.out = proxy;
        }
    }
}

