/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.vshell.registry.CommandCatalog;

public class CommandRegistry
implements CommandCatalog {
    private Map<String, Multimap<ExecSite, String>> toolToSiteToCmd = new HashMap<String, Multimap<ExecSite, String>>();

    public Optional<Multimap<ExecSite, String>> getKnownExecSites(String command) {
        Multimap tmp = this.toolToSiteToCmd.get(command);
        Multimap result = tmp != null ? Multimaps.filterKeys(this.toolToSiteToCmd.get(command), k -> !tmp.get(k).isEmpty()) : tmp;
        return Optional.ofNullable(result);
    }

    public Optional<Set<String>> getAvailability(String command, ExecSite execSite) {
        return Optional.ofNullable(this.toolToSiteToCmd.get(command)).map(mm -> (Set)mm.get((Object)execSite));
    }

    public CommandRegistry put(String command, ExecSite execSite, String cmd) {
        this.toolToSiteToCmd.computeIfAbsent(command, c -> LinkedHashMultimap.create()).put((Object)execSite, (Object)cmd);
        return this;
    }

    public CommandRegistry putAll(String command, Multimap<ExecSite, String> cmdMap) {
        this.toolToSiteToCmd.computeIfAbsent(command, c -> LinkedHashMultimap.create()).putAll(cmdMap);
        return this;
    }

    @Override
    public Multimap<ExecSite, String> get(String virtualCommandName) {
        return this.getKnownExecSites(virtualCommandName).orElse((Multimap<ExecSite, String>)Multimaps.unmodifiableMultimap((Multimap)LinkedHashMultimap.create()));
    }
}

