/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.model.ExecSite;
import org.aksw.shellgebra.exec.model.ExecSiteDockerImage;
import org.aksw.shellgebra.exec.model.ExecSites;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;
import org.aksw.shellgebra.processbuilder.ProcessBuilderDocker;
import org.aksw.shellgebra.shim.core.JvmCommandParser;
import org.aksw.vshell.registry.CmdOpVisitorToBase;
import org.aksw.vshell.registry.CommandCatalog;
import org.aksw.vshell.registry.ExecSiteToProcessDispatcher;
import org.aksw.vshell.registry.JvmCommandRegistry;

public class CmdOpVisitorToPbDocker
extends CmdOpVisitorToBase {
    protected ExecSiteDockerImage execSite;

    public CmdOpVisitorToPbDocker(ExecSiteToProcessDispatcher dispatcher, ExecSiteDockerImage execSite) {
        super(dispatcher);
        this.execSite = execSite;
    }

    @Override
    protected IProcessBuilderCore<?> toProcessBuilder(List<String> args) {
        ExecSiteToProcessDispatcher dispatcher = this.getDispatcher();
        String commandName = args.get(0);
        CommandCatalog commandCatalog = dispatcher.getCommandCatalog();
        JvmCommandRegistry commandRegistry = dispatcher.getContext().getJvmCmdRegistry();
        JvmCommandParser parser = null;
        Set parserCands = commandCatalog.get(commandName, ExecSites.jvm()).orElse(null);
        String parserCand = null;
        if (parserCands != null) {
            for (String tmp : parserCands) {
                parser = commandRegistry.get(tmp).orElse(null);
                if (parser == null) continue;
                parserCand = tmp;
                break;
            }
        }
        if (parser == null) {
            throw new RuntimeException("No command parser found for: " + commandName);
        }
        String actualCommandName = CmdOpVisitorToPbDocker.resolveOrFail(commandCatalog, commandName, this.execSite);
        ArrayList<String> newArgs = new ArrayList<String>(args);
        newArgs.set(0, actualCommandName);
        String imageRef = this.execSite.imageRef();
        FileMapper fileMapper = dispatcher.getFileMapper();
        ProcessBuilderDocker result = ProcessBuilderDocker.of(newArgs).commandParser(parser).imageRef(imageRef).fileMapper(fileMapper);
        return result;
    }

    public static String resolveOrFail(CommandCatalog commandCatalog, String commandName, ExecSite execSite) {
        Set<String> nameCands = commandCatalog.get(commandName, execSite).orElseThrow(() -> new RuntimeException("command " + commandName + " not found on exec site " + String.valueOf(execSite)));
        if (nameCands.isEmpty()) {
            throw new RuntimeException("Command " + commandName + " does not have resolutions on exec site " + String.valueOf(execSite));
        }
        String resolvedName = nameCands.iterator().next();
        return resolvedName;
    }
}

