/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.vshell.registry;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.aksw.commons.util.list.ListUtils;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArgVisitorRenderAsBashString;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpGroup;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpPipeline;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVisitor;
import org.aksw.shellgebra.exec.io.StageGroup;
import org.aksw.shellgebra.exec.stage.Stage;
import org.aksw.shellgebra.exec.stage.StagePipeline;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.vshell.registry.ExecSiteResolver;
import org.aksw.vshell.registry.JvmCommandRegistry;

public class CmdOpVisitorExecJvm
implements CmdOpVisitor<Stage> {
    private ExecSiteResolver resolver;
    private Function<CmdOpVar, Stage> varResolver;

    public CmdOpVisitorExecJvm(ExecSiteResolver resolver, Function<CmdOpVar, Stage> varResolver) {
        this.resolver = resolver;
        this.varResolver = varResolver;
    }

    @Override
    public Stage visit(CmdOpExec op) {
        String cmdName = op.getName();
        JvmCommandRegistry jvmCmdRegistry = this.resolver.getJvmCmdRegistry();
        String resolvedCmdName = cmdName;
        ArgumentList args = op.args();
        List<String> strs = CmdArgVisitorRenderAsBashString.render(args.args());
        String[] strArr = (String[])strs.toArray(String[]::new);
        Stage result = null;
        return result;
    }

    protected List<Stage> toStages(List<CmdOp> ops) {
        List result = ListUtils.map(ops, op -> op.accept(this));
        return result;
    }

    @Override
    public Stage visit(CmdOpPipeline op) {
        List<CmdOp> subOps = op.getSubOps();
        List<Stage> stages = this.toStages(subOps);
        Stage result = stages.size() == 1 ? stages.get(0) : new StagePipeline(stages);
        return result;
    }

    @Override
    public Stage visit(CmdOpGroup op) {
        List<CmdOp> subOps = op.subOps();
        List<Stage> stages = this.toStages(subOps);
        StageGroup result = new StageGroup(stages);
        return result;
    }

    @Override
    public Stage visit(CmdOpVar op) {
        Stage result = this.varResolver == null ? null : this.varResolver.apply(op);
        Objects.requireNonNull(result, "Could not resolve variable: " + String.valueOf(op));
        return result;
    }
}

