/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.aksw.shellgebra.algebra.cmd.arg.CmdArg;
import org.aksw.shellgebra.shim.core.ArgumentList;

public class ArgumentListBuilder {
    private final List<CmdArg> args = new ArrayList<CmdArg>();

    public ArgumentListBuilder opt(String name, String value) {
        Objects.requireNonNull(name);
        if (value != null) {
            this.args.add(CmdArg.ofLiteral(name));
            this.args.add(CmdArg.ofString(value));
        }
        return this;
    }

    public ArgumentListBuilder ifTrue(boolean value, String arg) {
        Objects.requireNonNull(arg);
        if (value) {
            this.args.add(CmdArg.ofLiteral(arg));
        }
        return this;
    }

    public ArgumentListBuilder arg(String value) {
        if (value != null) {
            this.args.add(CmdArg.ofString(value));
        }
        return this;
    }

    public ArgumentListBuilder fileOrLiteral(String filename, String fallbackLiteral) {
        Objects.requireNonNull(fallbackLiteral);
        if (filename != null) {
            this.args.add(CmdArg.ofPathString(filename));
        } else {
            this.args.add(CmdArg.ofLiteral(fallbackLiteral));
        }
        return this;
    }

    public ArgumentListBuilder arg(String value, String fallback) {
        if (value != null) {
            this.args.add(CmdArg.ofLiteral(value));
        } else if (fallback != null) {
            this.args.add(CmdArg.ofLiteral(fallback));
        }
        return this;
    }

    public ArgumentListBuilder args(List<String> list) {
        if (list != null) {
            for (String item : list) {
                this.args.add(CmdArg.ofLiteral(item));
            }
        }
        return this;
    }

    public ArgumentListBuilder files(List<String> list) {
        if (list != null) {
            for (String item : list) {
                CmdArg arg = "-".equals(item) ? CmdArg.ofLiteral(item) : CmdArg.ofPathString(item);
                this.args.add(arg);
            }
        }
        return this;
    }

    public ArgumentList build() {
        return new ArgumentList(this.args);
    }

    public static ArgumentListBuilder newBuilder() {
        return new ArgumentListBuilder();
    }
}

