/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.util.ArrayList;
import java.util.List;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.shim.core.ArgumentListBuilder;
import org.aksw.shellgebra.shim.picocli.ArgsParserPicocli;
import picocli.CommandLine;

public class RapperArgs {
    @CommandLine.Option(names={"-i"}, description={"Input format"})
    String inputFormat;
    @CommandLine.Option(names={"-o"}, description={"Output format"})
    String outputFormat;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Input file (use '-' for stdin)"})
    String inputFile;
    @CommandLine.Parameters(index="1", arity="0..1", description={"Base URL"})
    String baseUrl;
    @CommandLine.Unmatched
    List<String> unmatchedArgs = new ArrayList<String>();

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getUnmatchedArgs() {
        return this.unmatchedArgs;
    }

    public static ArgumentList renderArgList(RapperArgs model) {
        ArgumentList result = ArgumentListBuilder.newBuilder().opt("-i", model.getInputFormat()).opt("-o", model.getOutputFormat()).fileOrLiteral(model.getInputFile(), "-").arg(model.getBaseUrl()).args(model.getUnmatchedArgs()).build();
        return result;
    }

    public static ArgsModular<RapperArgs> parse(String[] args) {
        RapperArgs model = ArgsParserPicocli.of(RapperArgs::new).parse(args);
        return new ArgsModular<RapperArgs>(model, RapperArgs::renderArgList, a -> a.getInputFile().equals("-"));
    }

    public String toString() {
        return "inputFormat=" + this.inputFormat + ", outputFormat=" + this.outputFormat + ", inputFile=" + this.inputFile + ", baseUrl=" + this.baseUrl + ", unmatchedArgs=" + String.valueOf(this.unmatchedArgs);
    }
}

