/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.shellgebra.shim.cmd.ArgsHead;
import org.aksw.shellgebra.shim.cmd.JvmCommandBase;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.vshell.registry.JvmExecCxt;
import org.apache.commons.exec.ExecuteException;

public class JvmCommandHead
extends JvmCommandBase<ArgsHead> {
    @Override
    public ArgsModular<ArgsHead> parseArgs(String ... args) {
        ArgsModular<ArgsHead> result = ArgsHead.parse(args);
        return result;
    }

    @Override
    public void runActual(JvmExecCxt cxt, ArgsHead model) throws ExecuteException {
        boolean exitValue = false;
        List<String> names = model.getFileNames().isEmpty() ? List.of("-") : model.getFileNames();
        for (String name : names) {
            try {
                if (name.equals("-")) {
                    cxt.in().reader(StandardCharsets.UTF_8).lines().limit(model.getLines().orElse(10L)).forEach(cxt.out().printStream()::println);
                    continue;
                }
                Path path = Path.of(name, new String[0]);
                BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    Stream<String> stream = reader.lines().limit(model.getLines().orElse(10L));
                    try {
                        stream.forEach(cxt.out().printStream()::println);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(cxt.err().printStream());
                exitValue = true;
                break;
            }
        }
        if (exitValue) {
            throw new ExecuteException("One or more arguments failed to open as files.", 1);
        }
    }
}

