/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.shim.cmd;

import java.util.ArrayList;
import java.util.List;
import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.shellgebra.shim.core.ArgumentList;
import org.aksw.shellgebra.shim.core.ArgumentListBuilder;
import org.aksw.shellgebra.shim.picocli.ArgsParserPicocli;
import picocli.CommandLine;

public class ArgsWhich {
    @CommandLine.Option(names={"-a"}, description={"Print all matching pathnames of each argument"})
    boolean all;
    @CommandLine.Option(names={"-s"}, description={"Silently return 0 if all of the executables were found or 1 otherwise"})
    boolean silent;
    @CommandLine.Parameters(arity="0..*", description={"File names"})
    public List<String> fileNames = new ArrayList<String>();

    public boolean isAll() {
        return this.all;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public String toString() {
        return "ArgsWhich [all=" + this.all + ", silent=" + this.silent + ", files=" + String.valueOf(this.fileNames) + "]";
    }

    public static ArgumentList renderArgList(ArgsWhich model) {
        ArgumentList result = ArgumentListBuilder.newBuilder().ifTrue(model.isAll(), "-a").ifTrue(model.isSilent(), "-s").args(model.getFileNames()).build();
        return result;
    }

    public static Boolean stdinTest(ArgsWhich args) {
        return args.getFileNames().isEmpty() || args.getFileNames().contains("-");
    }

    public static ArgsModular<ArgsWhich> parse(String[] args) {
        ArgsWhich model = ArgsParserPicocli.of(ArgsWhich::new).parse(args);
        return new ArgsModular<ArgsWhich>(model, ArgsWhich::renderArgList, ArgsWhich::stdinTest);
    }
}

