/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.testcontainers.DockerClientFactory;

public class ProcessDockerExec
extends Process {
    private final DockerClient docker;
    private final String containerId;
    private final String execId;
    private final PipedInputStream stdoutIn = new PipedInputStream();
    private final PipedInputStream stderrIn = new PipedInputStream();
    private final PipedOutputStream stdinOut = new PipedOutputStream();
    private final PipedOutputStream stdoutSink;
    private final PipedOutputStream stderrSink;
    private final PipedInputStream stdinIn;
    private final CountDownLatch finished = new CountDownLatch(1);
    private volatile Long exitCode = null;
    private volatile boolean started = false;
    private volatile ResultCallback<Frame> callback;

    public ProcessDockerExec(String containerId, String ... cmd) throws IOException {
        this.docker = DockerClientFactory.instance().client();
        this.containerId = Objects.requireNonNull(containerId, "containerId");
        this.stdoutSink = new PipedOutputStream(this.stdoutIn);
        this.stderrSink = new PipedOutputStream(this.stderrIn);
        this.stdinIn = new PipedInputStream(this.stdinOut);
        ExecCreateCmdResponse created = (ExecCreateCmdResponse)this.docker.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(cmd).exec();
        this.execId = created.getId();
        this.callback = this.docker.execStartCmd(this.execId).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(false)).withStdIn((InputStream)this.stdinIn).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

            public void onStart(Closeable closeable) {
                ProcessDockerExec.this.started = true;
            }

            public void onNext(Frame frame) {
                try {
                    if (frame.getStreamType() == StreamType.STDOUT) {
                        ProcessDockerExec.this.stdoutSink.write(frame.getPayload());
                        ProcessDockerExec.this.stdoutSink.flush();
                    } else if (frame.getStreamType() == StreamType.STDERR) {
                        ProcessDockerExec.this.stderrSink.write(frame.getPayload());
                        ProcessDockerExec.this.stderrSink.flush();
                    }
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }

            public void onError(Throwable throwable) {
                try {
                    ProcessDockerExec.this.exitCode = ProcessDockerExec.this.docker.inspectExecCmd(ProcessDockerExec.this.execId).exec().getExitCodeLong();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ProcessDockerExec.this.finished.countDown();
                super.onError(throwable);
            }

            public void onComplete() {
                try {
                    ProcessDockerExec.this.stdoutSink.flush();
                    ProcessDockerExec.this.stderrSink.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    ProcessDockerExec.this.exitCode = ProcessDockerExec.this.docker.inspectExecCmd(ProcessDockerExec.this.execId).exec().getExitCodeLong();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ProcessDockerExec.this.finished.countDown();
                super.onComplete();
            }
        });
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdinOut;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdoutIn;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderrIn;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.finished.await();
        return this.exitValue();
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        boolean done = this.finished.await(timeout, unit);
        if (done) {
            this.exitValue();
        }
        return done;
    }

    @Override
    public int exitValue() {
        Long code = this.exitCode;
        if (code == null) {
            try {
                code = this.docker.inspectExecCmd(this.execId).exec().getExitCodeLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (code == null) {
            throw new IllegalThreadStateException("Process not yet finished");
        }
        return code.intValue();
    }

    @Override
    public void destroy() {
        try {
            this.stdinOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.callback != null) {
                this.callback.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    @Override
    public boolean isAlive() {
        if (!this.started) {
            return true;
        }
        try {
            return this.docker.inspectExecCmd(this.execId).exec().getExitCodeLong() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String readAllStdout() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (InputStream in = this.getInputStream();){
            in.transferTo(buf);
        }
        return buf.toString(StandardCharsets.UTF_8);
    }
}

