/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.processbuilder;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aksw.shellgebra.exec.graph.JRedirect;
import org.aksw.shellgebra.processbuilder.IProcessBuilderCore;

public abstract class ProcessBuilderCore<X extends ProcessBuilderCore<X>>
implements IProcessBuilderCore<X> {
    private Path directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private List<JRedirect> redirects = new ArrayList<JRedirect.JRedirectJava>(List.of(new JRedirect.JRedirectJava(ProcessBuilder.Redirect.INHERIT), new JRedirect.JRedirectJava(ProcessBuilder.Redirect.INHERIT), new JRedirect.JRedirectJava(ProcessBuilder.Redirect.INHERIT)));

    protected X self() {
        return (X)this;
    }

    public ProcessBuilderCore() {
        this.environment = new LinkedHashMap<String, String>();
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public X directory(Path directory) {
        this.directory = directory;
        return this.self();
    }

    @Override
    public Map<String, String> environment() {
        return this.environment;
    }

    @Override
    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    @Override
    public X redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this.self();
    }

    @Override
    public X redirectInput(JRedirect redirect) {
        Objects.requireNonNull(redirect, "redirectInput");
        this.redirects.set(0, redirect);
        return this.self();
    }

    @Override
    public JRedirect redirectInput() {
        return this.redirects.get(0);
    }

    @Override
    public X redirectOutput(JRedirect redirect) {
        Objects.requireNonNull(redirect, "redirectOutput");
        this.redirects.set(1, redirect);
        return this.self();
    }

    @Override
    public JRedirect redirectOutput() {
        return this.redirects.get(1);
    }

    @Override
    public X redirectError(JRedirect redirect) {
        Objects.requireNonNull(redirect, "redirectError");
        this.redirects.set(2, redirect);
        return this.self();
    }

    @Override
    public JRedirect redirectError() {
        return this.redirects.get(2);
    }

    @Override
    public X clone() {
        X result = this.cloneActual();
        this.applySettings((ProcessBuilderCore<?>)result);
        return result;
    }

    protected void applySettings(ProcessBuilderCore<?> target) {
        target.environment().putAll(this.environment());
        target.directory(this.directory());
        target.redirectErrorStream(this.redirectErrorStream());
        target.redirectInput(this.redirectInput());
        target.redirectOutput(this.redirectOutput());
        target.redirectError(this.redirectError());
    }

    protected abstract X cloneActual();
}

