/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.github.dockerjava.api.model.AccessMode;
import com.google.common.io.ByteSource;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.util.docker.ContainerPathResolver;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpVar;
import org.aksw.shellgebra.algebra.cmd.transform.FileMapper;
import org.aksw.shellgebra.exec.stage.BoundStage;
import org.aksw.shellgebra.exec.stage.BoundStageDocker;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskFromByteSource;
import org.aksw.shellgebra.exec.stage.Stage;
import org.aksw.shellgebra.util.PathLifeCycles;

public class StageDocker
implements Stage {
    protected String imageRef;
    protected CmdOp cmdOp;
    protected FileMapper fileMapper;
    protected ContainerPathResolver containerPathResolver;
    protected Function<CmdOpVar, Stage> varResolver;

    public StageDocker(String imageRef, CmdOp cmdOp, FileMapper fileMapper, ContainerPathResolver containerPathResolver, Function<CmdOpVar, Stage> varResolver) {
        this.imageRef = imageRef;
        this.cmdOp = cmdOp;
        this.fileMapper = fileMapper;
        this.containerPathResolver = containerPathResolver;
        this.varResolver = varResolver;
    }

    @Override
    public BoundStage from(ByteSource input) {
        Map.Entry<Path, String> map = this.fileMapper.allocateTempFile("byteSource", "", AccessMode.ro);
        Path hostPath = map.getKey();
        FileWriterTaskFromByteSource inputTask = new FileWriterTaskFromByteSource(hostPath, PathLifeCycles.namedPipe(), input);
        BoundStage result = this.from(inputTask);
        return result;
    }

    @Override
    public BoundStage from(FileWriterTask inputTask) {
        return new BoundStageDocker(this.imageRef, this.cmdOp, this.fileMapper, this.containerPathResolver, inputTask, null, this.varResolver);
    }

    @Override
    public BoundStage from(BoundStage input) {
        return new BoundStageDocker(this.imageRef, this.cmdOp, this.fileMapper, this.containerPathResolver, null, input, this.varResolver);
    }

    @Override
    public BoundStage fromNull() {
        return new BoundStageDocker(this.imageRef, this.cmdOp, this.fileMapper, this.containerPathResolver, null, null, this.varResolver);
    }
}

