/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.stage;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.aksw.commons.io.util.stream.OutputStreamTransform;
import org.aksw.shellgebra.exec.stage.FileWriterTask;
import org.aksw.shellgebra.exec.stage.FileWriterTaskViaExecutor;
import org.aksw.shellgebra.util.PathLifeCycle;
import org.apache.commons.exec.ExecuteException;

public class FileWriterTaskFromProcessBuilder
extends FileWriterTaskViaExecutor {
    private List<ProcessBuilder> processBuilders;
    private List<Process> processes;
    private List<FileWriterTask> inputTasks;
    private ByteSource inputSource;
    private OutputStreamTransform outputTransform;

    public FileWriterTaskFromProcessBuilder(Path outputPath, PathLifeCycle pathLifeCycle, List<ProcessBuilder> processBuilders, List<FileWriterTask> inputTasks, ByteSource inputSource, OutputStreamTransform outputTransform) {
        super(outputPath, pathLifeCycle);
        this.processBuilders = processBuilders;
        this.inputTasks = inputTasks;
        this.inputSource = inputSource;
        this.outputTransform = Optional.ofNullable(outputTransform).orElse(o -> o);
    }

    protected final void beforeExec() throws IOException {
        this.pathLifeCycle.beforeExec(this.outputPath);
    }

    @Override
    protected void prepareWriteFile() throws IOException {
    }

    @Override
    public void runWriteFile() throws ExecuteException, IOException {
        for (FileWriterTask inputTask : this.inputTasks) {
            inputTask.start();
        }
        this.processes = ProcessBuilder.startPipeline(this.processBuilders);
        if (this.inputSource != null) {
            Process firstProcess = this.processes.get(0);
            try (OutputStream out = this.outputTransform.apply(firstProcess.getOutputStream());){
                try (InputStream in = this.inputSource.openStream();){
                    in.transferTo(out);
                }
                out.flush();
            }
        }
    }

    @Override
    public void abortActual() {
        for (FileWriterTask inputTask : this.inputTasks) {
            inputTask.abort();
        }
        for (Process process : this.processes) {
            process.destroy();
        }
    }

    @Override
    protected void onCompletion() throws IOException {
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

