/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.invocation;

import java.io.IOException;
import java.util.List;
import org.aksw.shellgebra.exec.graph.ProcessRunner;
import org.aksw.shellgebra.exec.invocation.CompileContext;
import org.aksw.shellgebra.exec.invocation.ExecutableInvocation;
import org.aksw.shellgebra.exec.invocation.Invocation;
import org.aksw.shellgebra.exec.invocation.InvocationCompiler;
import org.aksw.shellgebra.exec.invocation.InvocationCompilerImpl;
import org.aksw.shellgebra.exec.invocation.InvokableProcessBuilderBase;
import org.aksw.vshell.registry.ProcessBuilderNative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokableProcessBuilderHost
extends InvokableProcessBuilderBase<InvokableProcessBuilderHost> {
    private static final Logger logger = LoggerFactory.getLogger(InvokableProcessBuilderHost.class);
    private InvocationCompiler compiler = null;

    public static InvokableProcessBuilderHost of(List<String> args) {
        return (InvokableProcessBuilderHost)new InvokableProcessBuilderHost().command(args);
    }

    @Override
    protected InvokableProcessBuilderHost cloneActual() {
        return new InvokableProcessBuilderHost();
    }

    public InvokableProcessBuilderHost compiler(InvocationCompiler compiler) {
        this.compiler = compiler;
        return (InvokableProcessBuilderHost)this.self();
    }

    public InvocationCompiler compiler() {
        return this.compiler;
    }

    @Override
    public Process start(ProcessRunner executor) throws IOException {
        CompileContext ctx = CompileContext.noResolve();
        Invocation inv = this.invocation();
        if (inv == null) {
            throw new IllegalStateException("No invocation set");
        }
        InvocationCompiler finalCompiler = this.compiler != null ? this.compiler : InvocationCompilerImpl.getDefault();
        ExecutableInvocation exec = finalCompiler.compile(inv, ctx);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(exec.argv());
        ProcessBuilderNative.configure(pb, this, executor);
        Process p = pb.start();
        p.toHandle().onExit().thenRun(() -> {
            try {
                exec.close();
            }
            catch (Exception e) {
                logger.warn("Error during close", (Throwable)e);
            }
        });
        return p;
    }

    @Override
    public boolean supportsAnonPipeRead() {
        return true;
    }

    @Override
    public boolean supportsAnonPipeWrite() {
        return true;
    }

    @Override
    public boolean supportsDirectNamedPipe() {
        return true;
    }

    @Override
    public boolean accessesStdIn() {
        return true;
    }
}

