/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.util.Arrays;
import java.util.Objects;
import org.aksw.shellgebra.exec.graph.FileDescription;

public class FdTable<T>
implements AutoCloseable {
    private FileDescription<T>[] fileDescriptions;

    public FdTable() {
        this(3);
    }

    public FdTable(int initialSize) {
        this(new FileDescription[initialSize]);
    }

    public FdTable(FileDescription<T>[] fileDescriptions) {
        this.fileDescriptions = fileDescriptions;
    }

    public T getResource(int id) {
        return this.getFd(id).get();
    }

    public FileDescription<T> getFd(int id) {
        FileDescription<T> result = this.fileDescriptions[id];
        if (result == null) {
            throw new IllegalArgumentException("no such fd: " + id);
        }
        return result;
    }

    public synchronized FdTable<T> dup() {
        FileDescription<T>[] copy = FdTable.dup(this.fileDescriptions);
        return new FdTable<T>(copy);
    }

    public void closeFd(int id) {
        this.fileDescriptions[id].close();
        this.fileDescriptions[id] = null;
    }

    public void alloc(int n) {
        if (n > this.fileDescriptions.length) {
            this.fileDescriptions = Arrays.copyOf(this.fileDescriptions, n);
        }
    }

    public void setFd(int tgt, FileDescription<T> newer) {
        Objects.requireNonNull(newer);
        this.setFd(tgt, -1, newer);
    }

    public void dup2(int tgt, int src) {
        FileDescription<T> srcFd = this.fileDescriptions[src];
        if (srcFd == null) {
            throw new IllegalArgumentException("no fd with id " + src);
        }
        FileDescription<T> newer = srcFd.dup();
        this.setFd(tgt, src, newer);
    }

    private void setFd(int tgt, int dupSrc, FileDescription<T> newer) {
        this.alloc(tgt);
        FileDescription<T> old = this.fileDescriptions[tgt];
        if (old != null && old != newer) {
            old.close();
        }
        if (!newer.isOpen()) {
            throw new IllegalArgumentException("fd already closed - duplicated from " + dupSrc);
        }
        this.fileDescriptions[tgt] = newer;
    }

    private static <T> FileDescription<T>[] dup(FileDescription<T>[] fileDescriptions) {
        int n = fileDescriptions.length;
        FileDescription[] fds = new FileDescription[n];
        for (int i = 0; i < n; ++i) {
            FileDescription<T> copy;
            FileDescription<T> orig = fileDescriptions[i];
            if (orig == null || !(copy = orig.dup()).isOpen()) continue;
            fds[i] = copy;
        }
        return fds;
    }

    @Override
    public void close() {
        for (FileDescription<T> fd : this.fileDescriptions) {
            if (fd == null) continue;
            fd.close();
        }
    }
}

