/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec.graph;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.shellgebra.exec.graph.FileDescription;

public interface FdResource
extends AutoCloseable {
    default public InputStream asInputStream() {
        throw new RuntimeException("not an input stream");
    }

    default public OutputStream asOutputStream() {
        throw new RuntimeException("not an uutput stream");
    }

    @Override
    public void close() throws IOException;

    public static FileDescription<FdResourcePath> castAsFdPath(FileDescription<FdResource> fd) {
        if (fd.get() instanceof FdResourcePath) {
            return fd;
        }
        return null;
    }

    public static FdResourceInputStream openRead(FileDescription<FdResourcePath> fd) throws IOException {
        InputStream is;
        FileDescription<FdResourcePath> dup = fd.checkedDup();
        Path path = dup.get().path();
        try {
            is = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            dup.close();
            throw new IOException(e);
        }
        return new FdResourceInputStream(is, dup);
    }

    public static FdResource openWrite(FileDescription<FdResourcePath> fd) throws IOException {
        return FdResource.openWriteInternal(fd, new OpenOption[0]);
    }

    public static FdResource openAppend(FileDescription<FdResourcePath> fd) throws IOException {
        return FdResource.openWriteInternal(fd, StandardOpenOption.APPEND);
    }

    private static FdResource openWriteInternal(FileDescription<FdResourcePath> fd, OpenOption ... options) throws IOException {
        OutputStream os;
        FileDescription<FdResourcePath> dup = fd.checkedDup();
        Path path = dup.get().path();
        try {
            os = Files.newOutputStream(path, options);
        }
        catch (IOException e) {
            dup.close();
            throw new IOException(e);
        }
        return new FdResourceOutputStream(os, dup);
    }

    public static FdResource of(InputStream is) {
        return new FdResourceInputStream(is, null);
    }

    public static FdResource of(OutputStream os) {
        return new FdResourceOutputStream(os, null);
    }

    public static FdResource of(Path path) {
        return new FdResourcePath(path);
    }

    public record FdResourcePath(Path path) implements FdResource
    {
        @Override
        public void close() throws IOException {
        }
    }

    public record FdResourceInputStream(InputStream inputStream, FileDescription<FdResourcePath> base) implements FdResource
    {
        @Override
        public InputStream asInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() throws IOException {
            try {
                this.inputStream.close();
            }
            finally {
                if (this.base != null) {
                    this.base.close();
                }
            }
        }
    }

    public record FdResourceOutputStream(OutputStream outputStream, FileDescription<FdResourcePath> base) implements FdResource
    {
        @Override
        public OutputStream asOutputStream() {
            return this.outputStream;
        }

        @Override
        public void close() throws IOException {
            try {
                this.outputStream.close();
            }
            finally {
                if (this.base != null) {
                    this.base.close();
                }
            }
        }
    }
}

