/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import org.aksw.commons.util.docker.Argv;
import org.aksw.commons.util.docker.ImageIntrospectorImpl;
import org.aksw.shellgebra.exec.ListBuilder;
import org.aksw.shellgebra.exec.SysRuntimeCoreDocker;
import org.aksw.shellgebra.exec.SysRuntimeDocker;
import org.aksw.shellgebra.introspect.ShellCatalogEntry;
import org.aksw.shellgebra.introspect.ShellProbeResult;
import org.aksw.shellgebra.model.osreo.ImageIntrospector;
import org.aksw.vshell.registry.ExecSiteProbeResults;

public class SysRuntimeFactoryDocker {
    private ImageIntrospector imageIntrospector;
    private Table<String, Argv, Boolean> imageToEntrypoints;
    private ExecSiteProbeResults probeResults;
    private Table<String, String, ShellProbeResult> imageToShellToProbeResult = HashBasedTable.create();
    private static SysRuntimeFactoryDocker instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SysRuntimeFactoryDocker get() {
        if (instance != null) return instance;
        Class<SysRuntimeFactoryDocker> clazz = SysRuntimeFactoryDocker.class;
        synchronized (SysRuntimeFactoryDocker.class) {
            if (instance != null) return instance;
            instance = SysRuntimeFactoryDocker.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SysRuntimeFactoryDocker(ImageIntrospector imageIntrospector, Table<String, Argv, Boolean> imageToEntrypoints, ExecSiteProbeResults probeResults) {
        this.imageIntrospector = imageIntrospector;
        this.imageToEntrypoints = imageToEntrypoints;
        this.probeResults = probeResults;
    }

    public static SysRuntimeFactoryDocker create() {
        ExecSiteProbeResults probeResults = ExecSiteProbeResults.get();
        HashBasedTable imageToEntrypoints = HashBasedTable.create();
        ImageIntrospector imageIntrospector = ImageIntrospectorImpl.of();
        return new SysRuntimeFactoryDocker(imageIntrospector, (Table<String, Argv, Boolean>)imageToEntrypoints, probeResults);
    }

    public ExecSiteProbeResults getProbeResults() {
        return this.probeResults;
    }

    public SysRuntimeCoreDocker createCore(String imageRef) {
        return this.createCore(imageRef, true);
    }

    public SysRuntimeCoreDocker createCore(String imageRef, boolean pullIfAbsent) {
        List<Argv> keepAliveCmdCatalog = ImageIntrospectorImpl.getKeepAliveCatalog();
        SysRuntimeCoreDocker core = ImageIntrospectorImpl.startKeptAlive(imageRef, keepAliveCmdCatalog, this.probeResults);
        return core;
    }

    public SysRuntimeDocker create(String imageRef) {
        List<ShellCatalogEntry> shellCatalog = ImageIntrospectorImpl.getShellCatalog();
        List<ShellCatalogEntry> bashCatalog = ImageIntrospectorImpl.getShellSubCatalog(shellCatalog, "bash");
        ShellCatalogEntry shellEntry = bashCatalog.get(0);
        SysRuntimeCoreDocker core = this.createCore(imageRef, true);
        ShellProbeResult shellProbeResult = this.imageIntrospector.findShell(core, shellEntry);
        Argv entrypointArgv = Argv.ofArgs(shellProbeResult.location(), ListBuilder.ofString().addAllNonNull((String[])new String[]{shellProbeResult.commandOption()}).buildList());
        String locatorCmd = shellProbeResult.locatorCommand();
        Argv locatorArgv = locatorCmd == null ? null : Argv.of(locatorCmd);
        Argv existsCmd = Argv.of("test", "-e");
        SysRuntimeDocker result = new SysRuntimeDocker(core, locatorArgv, existsCmd);
        return result;
    }

    public ShellProbeResult findShell(String imageRef, boolean pullIfAbsent, String shellName) {
        ShellProbeResult result = (ShellProbeResult)this.imageToShellToProbeResult.get((Object)imageRef, (Object)shellName);
        if (result == null) {
            List<ShellCatalogEntry> shellCatalog = ImageIntrospectorImpl.getShellCatalog();
            List<ShellCatalogEntry> bashCatalog = ImageIntrospectorImpl.getShellSubCatalog(shellCatalog, shellName);
            try (SysRuntimeCoreDocker runtime = this.createCore(imageRef, pullIfAbsent);){
                for (ShellCatalogEntry shellEntry : bashCatalog) {
                    ShellProbeResult probeResult = this.imageIntrospector.findShell(runtime, shellEntry);
                    if (probeResult == null) continue;
                    result = probeResult;
                    this.imageToShellToProbeResult.put((Object)imageRef, (Object)shellName, (Object)result);
                    break;
                }
            }
        }
        return result;
    }
}

