/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;

public class ListBuilder<T> {
    private List<T> list = new ArrayList<T>();
    private IntFunction<T[]> arrayConstructor;

    private ListBuilder(List<T> list, IntFunction<T[]> arrayConstructor) {
        this.list = list;
        this.arrayConstructor = arrayConstructor;
    }

    public ListBuilder<T> add(T item) {
        this.list.add(item);
        return this;
    }

    public ListBuilder<T> addAll(Collection<T> items) {
        this.list.addAll(items);
        return this;
    }

    public ListBuilder<T> addAll(T ... items) {
        this.list.addAll(Arrays.asList(items));
        return this;
    }

    public ListBuilder<T> addAllNonNull(T ... items) {
        for (T item : items) {
            if (item == null) continue;
            this.list.add(item);
        }
        return this;
    }

    public List<T> buildList() {
        return List.copyOf(this.list);
    }

    public T[] buildArray() {
        T[] result = this.list.toArray(this.arrayConstructor);
        return result;
    }

    public static ListBuilder<String> ofString(int initialCapacity) {
        return new ListBuilder<String>(new ArrayList(initialCapacity), String[]::new);
    }

    public static ListBuilder<String> ofString() {
        return new ListBuilder<String>(new ArrayList(), String[]::new);
    }

    public static <T> ListBuilder<T> of(Class<T> clz) {
        IntFunction<T[]> fn = i -> {
            try {
                Constructor arrayCtor = ((Class)clz.arrayType()).getConstructor(Integer.TYPE);
                return (Object[])arrayCtor.newInstance(i);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
        ListBuilder<T> result = ListBuilder.of(fn);
        return result;
    }

    public static <T> ListBuilder<T> of(IntFunction<T[]> fn) {
        return new ListBuilder(new ArrayList(), fn);
    }
}

