/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.exec;

import java.util.List;
import java.util.function.Function;
import org.aksw.shellgebra.algebra.cmd.op.CmdOpExec;
import org.aksw.shellgebra.exec.CommandRunner;
import org.aksw.shellgebra.exec.CommandRunnerWrapper;
import org.aksw.shellgebra.exec.ListTransformPrefix;
import org.aksw.shellgebra.exec.SysRuntimeImpl;

public class CommandRunnerWrapperBash<T>
extends CommandRunnerWrapper<T> {
    protected Function<List<String>, List<String>> shellCallTransform;

    public CommandRunnerWrapperBash(CommandRunner<T> delegate, List<String> prefix) {
        super(delegate);
        this.shellCallTransform = new ListTransformPrefix<String>(prefix);
    }

    @Override
    public T call(String ... argv) {
        CmdOpExec cmdOp = CmdOpExec.ofLiteralArgs(argv);
        String[] argArray = SysRuntimeImpl.forBash().compileCommand(cmdOp);
        List<String> argList = List.of(SysRuntimeImpl.quoteArg(SysRuntimeImpl.join(argArray)));
        List<String> newArgList = this.shellCallTransform.apply(argList);
        String[] newArgArray = (String[])newArgList.toArray(String[]::new);
        Object result = super.call(newArgArray);
        return result;
    }
}

