/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.shellgebra.algebra.cmd.transformer;

import java.util.Objects;
import org.aksw.shellgebra.algebra.cmd.arg.Token;
import org.aksw.shellgebra.algebra.cmd.op.CmdOp;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdArgTransform;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransform;
import org.aksw.shellgebra.algebra.cmd.transformer.CmdOpTransformer;
import org.aksw.shellgebra.algebra.cmd.transformer.TokenTransform;

public class TokenVisitorApplyTransform
implements Token.TokenVisitor<Token> {
    private TokenTransform tokenTransform;
    private CmdOpTransform cmdOpTransform;
    private CmdArgTransform cmdArgTransform;

    public TokenVisitorApplyTransform(TokenTransform transform, CmdOpTransform cmdOpTransform, CmdArgTransform cmdArgTransform) {
        this.tokenTransform = Objects.requireNonNull(transform);
        this.cmdOpTransform = Objects.requireNonNull(cmdOpTransform);
        this.cmdArgTransform = Objects.requireNonNull(cmdArgTransform);
    }

    @Override
    public Token visit(Token.TokenLiteral token) {
        Token result = this.tokenTransform.transform(token);
        return result;
    }

    @Override
    public Token visit(Token.TokenPath token) {
        Token result = this.tokenTransform.transform(token);
        return result;
    }

    @Override
    public Token visit(Token.TokenVar token) {
        Token result = this.tokenTransform.transform(token);
        return result;
    }

    @Override
    public Token visit(Token.TokenCmdOp token) {
        CmdOp inCmdOp = token.cmdOp();
        CmdOp outCmdOp = CmdOpTransformer.transform(inCmdOp, this.cmdOpTransform, this.cmdArgTransform, this.tokenTransform);
        Token result = this.tokenTransform.transform(token, outCmdOp);
        return result;
    }
}

