/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import org.testcontainers.DockerClientFactory;

public class ImageUtils {
    public static boolean imageExists(String imageName, boolean pullIfAbsent) {
        DockerClient client = DockerClientFactory.instance().client();
        boolean didPull = false;
        boolean result = false;
        while (true) {
            try {
                client.inspectImageCmd(imageName).exec();
                result = true;
            }
            catch (NotFoundException e) {
                if (didPull || !pullIfAbsent || !ImageUtils.pullImage(imageName)) break;
                didPull = true;
                continue;
            }
            break;
        }
        return result;
    }

    public static boolean pullImage(String imageName) {
        DockerClient client = DockerClientFactory.instance().client();
        boolean result = false;
        try {
            ((PullImageResultCallback)client.pullImageCmd(imageName).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

