package org.aksw.shellgebra.shim.cmd;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

import org.aksw.shellgebra.shim.core.ArgsModular;
import org.aksw.vshell.registry.JvmExecCxt;
import org.apache.commons.exec.ExecuteException;

public class JvmCommandCat
    extends JvmCommandBase<ArgsCat>
{
    @Override
    public ArgsModular<ArgsCat> parseArgs(String... args) {
        ArgsModular<ArgsCat> result = ArgsCat.parse(args);
        return result;
    }

    @Override
    public void runActual(JvmExecCxt cxt, ArgsCat model) throws ExecuteException {
        int exitValue = 0;
        List<String> names = model.getFileNames().isEmpty()
            ? List.of("-")
            : model.getFileNames();

        for (String name : names) {
            try {
                if (name.equals("-")) {
                    cxt.in().inputStream().transferTo(cxt.out().outputStream());
                } else {
                    Path path = Path.of(name);
                    try (InputStream in = Files.newInputStream(path)) {
                        in.transferTo(cxt.out().outputStream());
                    }
                }
            } catch (Exception e) {
                e.printStackTrace(cxt.err().printStream());
                exitValue = 1;
                break;
            }
        }

        if (exitValue != 0) {
            // TODO Improve exception - should we reuse ExecuteException or roll our own?
            throw new ExecuteException("One or more arguments failed to open as files.", 1);
        }
    }
}
