package org.aksw.shellgebra.exec.stage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;

import com.google.common.io.ByteSource;

import org.aksw.shellgebra.exec.TransformedByteSource;
import org.aksw.shellgebra.exec.TransformedByteSource.ByteSourceSplit;
import org.aksw.shellgebra.util.PathLifeCycle;

public class FileWriterTaskFromByteSource
    extends FileWriterTaskViaExecutor
{
    protected ByteSource byteSource;

    public FileWriterTaskFromByteSource(Path path, PathLifeCycle pathLifeCycle, ByteSource byteSource) {
        super(path, pathLifeCycle);
        this.byteSource = byteSource;
    }

    @Override
    protected void abortActual() {
        // TODO Auto-generated method stub

    }

    @Override
    protected void prepareWriteFile() throws IOException {
        // Nothing
    }

    @Override
    protected void runWriteFile() throws IOException {
        // Extract output stream transforms from the byte source and apply them on the output stream.
        // This can avoid some piped input/output streams.
        ByteSourceSplit split = TransformedByteSource.split(byteSource);
        ByteSource bs = split.byteSource();

        try (OutputStream out = split.outTransforms().apply(Files.newOutputStream(outputPath))) { //, StandardOpenOption.WRITE)) {
            try (InputStream in = bs.openStream()) {
                in.transferTo(out);
            }
            out.flush();
        }
    }
}
