/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.maven.plugin.ckan;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.exceptions.CkanException;
import eu.trentorise.opendata.jackan.exceptions.CkanNotFoundException;
import eu.trentorise.opendata.jackan.internal.org.apache.http.HttpEntity;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.CloseableHttpResponse;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.HttpPost;
import eu.trentorise.opendata.jackan.internal.org.apache.http.client.methods.HttpUriRequest;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.ContentType;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.mime.MultipartEntityBuilder;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.mime.content.ContentBody;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.mime.content.FileBody;
import eu.trentorise.opendata.jackan.internal.org.apache.http.entity.mime.content.StringBody;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client.CloseableHttpClient;
import eu.trentorise.opendata.jackan.internal.org.apache.http.impl.client.HttpClientBuilder;
import eu.trentorise.opendata.jackan.model.CkanDataset;
import eu.trentorise.opendata.jackan.model.CkanDatasetBase;
import eu.trentorise.opendata.jackan.model.CkanOrganization;
import eu.trentorise.opendata.jackan.model.CkanResource;
import eu.trentorise.opendata.jackan.model.CkanResourceBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

@Mojo(name="upload", defaultPhase=LifecyclePhase.DEPLOY)
public class CkanUploadMojo
extends AbstractMojo {
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private SettingsDecrypter decrypter;
    @Parameter(property="ckan.url", required=true)
    private String ckanUrl;
    @Parameter(property="ckan.serverId", required=true)
    private String serverId;
    @Parameter(property="ckan.uploadPath", required=true)
    private String uploadPath;
    @Parameter(property="ckan.downloadFileName", required=false)
    private String downloadFileName;
    @Parameter(property="ckan.datasetId", required=true)
    private String datasetId;
    @Parameter(property="ckan.resourceId", defaultValue="${project.artifactId}-${project.version}", required=true)
    private String resourceId;
    @Parameter(property="ckan.resourceName", defaultValue="${project.artifactId}-${project.version}", required=true)
    private String resourceName;
    @Parameter(property="ckan.resourceFormat", required=false)
    private String resourceFormat;
    @Parameter(property="ckan.organizationId", required=false)
    private String organizationId;
    @Parameter(property="ckan.author", required=false)
    private String author;
    @Parameter(property="ckan.apiKey", required=false)
    private String apiKey;

    public void execute() throws MojoExecutionException {
        Objects.requireNonNull(this.uploadPath, "Path to the file to be uploaded must not be null");
        Path path = Path.of(this.uploadPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("File " + String.valueOf(path.toAbsolutePath()) + " does not exist.");
        }
        try {
            Server server = this.settings.getServer(this.serverId);
            String $apiKey = this.apiKey;
            if ($apiKey == null && server != null) {
                SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
                server = result.getServer();
                $apiKey = server.getPassword();
            }
            CkanClient ckanClient = new CkanClient(this.ckanUrl, $apiKey);
            this.doDeploy(ckanClient, path);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error uploading file to CKAN", (Exception)e);
        }
    }

    public void doDeploy(CkanClient ckanClient, Path file) throws IOException {
        CkanDataset remoteCkanDataset;
        Log logger = this.getLog();
        String datasetName = this.datasetId.replace(":", "-").replace(".", "-").replace(" ", "-").toLowerCase();
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Post-processed name to " + datasetName));
        }
        boolean isDatasetCreationRequired = false;
        try {
            remoteCkanDataset = ckanClient.getDataset(datasetName);
        }
        catch (CkanNotFoundException e) {
            if (logger.isInfoEnabled()) {
                logger.info((CharSequence)"Dataset does not yet exist");
            }
            remoteCkanDataset = new CkanDataset();
            isDatasetCreationRequired = true;
        }
        catch (CkanException e) {
            remoteCkanDataset = new CkanDataset();
            isDatasetCreationRequired = true;
        }
        remoteCkanDataset.setGroups(null);
        CkanOrganization ckanOrg = null;
        if (this.organizationId != null) {
            ckanOrg = ckanClient.getOrganization(this.organizationId);
        }
        remoteCkanDataset.setAuthor(this.author);
        remoteCkanDataset.setVersion(this.project.getVersion());
        List licenses = this.project.getLicenses();
        if (!licenses.isEmpty()) {
            if (licenses.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((CharSequence)"More than 1 license found. Using only the first.");
            }
            License license = (License)licenses.get(0);
            remoteCkanDataset.setLicenseId(license.getName());
            remoteCkanDataset.setLicenseUrl(license.getUrl());
        }
        remoteCkanDataset.setNotes(this.project.getDescription());
        if (ckanOrg != null) {
            remoteCkanDataset.setOrganization(ckanOrg);
            remoteCkanDataset.setOwnerOrg(ckanOrg.getId());
        }
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Is creation required? " + isDatasetCreationRequired));
        }
        remoteCkanDataset.setName(datasetName);
        boolean replaceTags = false;
        Optional<List> existingTags = Optional.ofNullable(remoteCkanDataset.getTags());
        remoteCkanDataset = isDatasetCreationRequired ? ckanClient.createDataset((CkanDatasetBase)remoteCkanDataset) : ckanClient.updateDataset((CkanDatasetBase)remoteCkanDataset);
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Deploying distribution " + this.resourceId));
        }
        CkanResource remoteCkanResource = CkanUploadMojo.createOrUpdateResource(ckanClient, remoteCkanDataset, this.resourceId);
        if (file != null) {
            String probedContentType;
            block18: {
                probedContentType = null;
                try {
                    probedContentType = Files.probeContentType(file);
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block18;
                    logger.warn((CharSequence)("Failed to probe content type of " + String.valueOf(file)), (Throwable)e);
                }
            }
            String contentType = Optional.ofNullable(probedContentType).orElse(ContentType.APPLICATION_OCTET_STREAM.toString());
            String finalDownloadFileName = this.downloadFileName != null ? this.downloadFileName : file.getFileName().toString();
            logger.info((CharSequence)("Uploading file " + String.valueOf(file)));
            CkanResource tmp = this.uploadFile(ckanClient, remoteCkanDataset.getName(), remoteCkanResource.getId(), remoteCkanResource.getName(), file, ContentType.create((String)contentType), finalDownloadFileName);
            tmp.setFormat(this.resourceFormat);
            tmp.setOthers(remoteCkanResource.getOthers());
            int maxRetries = 5;
            for (int i = 0; i < maxRetries; ++i) {
                try {
                    remoteCkanResource = ckanClient.updateResource((CkanResourceBase)tmp);
                    break;
                }
                catch (Exception e) {
                    if (i + 1 < maxRetries) {
                        logger.warn((CharSequence)("Failed to update resource, retrying " + (i + 1) + "/" + maxRetries));
                        continue;
                    }
                    logger.error((CharSequence)("Giving up on updating a resource after " + maxRetries), (Throwable)e);
                    continue;
                }
            }
        }
    }

    public static CkanResource createOrUpdateResource(CkanClient ckanClient, CkanDataset ckanDataset, String resourceId) {
        ImmutableListMultimap nameToCkanResources = Multimaps.index((Iterable)Optional.ofNullable(ckanDataset.getResources()).orElse(Collections.emptyList()), CkanResourceBase::getName);
        String resName = resourceId;
        if (resName == null) {
            throw new RuntimeException("DCAT Distribution / CKAN Resource must have a name i.e. public id");
        }
        boolean isResourceCreationRequired = false;
        CkanResource remote = null;
        Collection remotes = nameToCkanResources.get((Object)resName);
        Iterator it = remotes.iterator();
        CkanResource ckanResource = remote = it.hasNext() ? (CkanResource)it.next() : null;
        while (it.hasNext()) {
            CkanResource tmp = (CkanResource)it.next();
            ckanClient.deleteResource(tmp.getId());
        }
        if (remote == null) {
            isResourceCreationRequired = true;
            remote = new CkanResource(null, ckanDataset.getId());
            remote.setName(resName);
        }
        remote = isResourceCreationRequired ? ckanClient.createResource((CkanResourceBase)remote) : ckanClient.updateResource((CkanResourceBase)remote);
        System.err.println("resource name: " + remote.getName());
        return remote;
    }

    public CkanResource uploadFile(CkanClient ckanClient, String datasetName, String resourceId, String resourceName, Path path, ContentType contentType, String downloadFilename) {
        CkanResource ckanResource;
        block9: {
            Log logger = this.getLog();
            contentType = contentType == null ? ContentType.DEFAULT_TEXT : contentType;
            String apiKey = ckanClient.getCkanToken();
            String HOST = ckanClient.getCatalogUrl();
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            try {
                CkanResource result;
                File file = path.toFile();
                HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("id", (ContentBody)new StringBody(resourceId, ContentType.TEXT_PLAIN)).addPart("name", (ContentBody)new StringBody(resourceName, ContentType.TEXT_PLAIN)).addPart("package_id", (ContentBody)new StringBody(datasetName, ContentType.TEXT_PLAIN)).addPart("upload", (ContentBody)new FileBody(file, contentType, downloadFilename)).build();
                String url = HOST + "/api/action/resource_update";
                HttpPost postRequest = new HttpPost(url);
                postRequest.setEntity(reqEntity);
                postRequest.setHeader("Authorization", apiKey);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)postRequest);
                int statusCode = response.getStatusLine().getStatusCode();
                String status = new BufferedReader(new InputStreamReader(response.getEntity().getContent())).lines().collect(Collectors.joining("\n"));
                if (logger.isInfoEnabled()) {
                    logger.info((CharSequence)("Upload status: " + statusCode + "\n" + status));
                }
                ckanResource = result = ckanClient.getResource(resourceId);
                if (httpclient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpclient != null) {
                        try {
                            httpclient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CkanException(e.getMessage(), ckanClient, (Throwable)e);
                }
            }
            httpclient.close();
        }
        return ckanResource;
    }

    public static Optional<Path> pathsGet(URI uri) {
        Optional<Path> result;
        try {
            result = Optional.of(Paths.get(uri));
        }
        catch (Exception e) {
            result = Optional.empty();
        }
        return result;
    }

    private void addProperty(StringBuilder builder, String boundaryPrefix, String key, String mimeType, String value) {
        builder.append(boundaryPrefix).append("\r\n").append("Content-Disposition: form-data; name=\"").append(key).append("\"").append("\r\n").append("\r\n").append(value).append("\r\n");
    }

    private String buildMultipartData(File file, String boundaryPrefix, String mimeType) throws IOException {
        StringBuilder builder = new StringBuilder();
        this.addProperty(builder, boundaryPrefix, "id", "text/plain", this.datasetId);
        builder.append(boundaryPrefix).append("\r\n");
        builder.append("Content-Disposition: form-data").append("; name=\"upload\"").append("; filename=\"").append(file.getName()).append('\"').append("\r\n");
        builder.append("Content-Type: ").append(mimeType).append("\r\n\r\n");
        builder.append(new String(Files.readAllBytes(file.toPath()), "UTF-8"));
        builder.append("\r\n").append(boundaryPrefix).append("--").append("\r\n");
        String result = builder.toString();
        System.err.println("String:\n" + result);
        return result;
    }
}

