/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.server.boot;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.jenax.web.frontend.ServerUtils;
import org.aksw.jenax.web.server.boot.ServletBuilder;
import org.aksw.jenax.web.util.WebAppInitUtils;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class ServerBuilder {
    protected Integer port;
    protected List<ServletBuilder> servletBuilders = new ArrayList<ServletBuilder>();

    public int getPort() {
        return this.port;
    }

    public ServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public ServerBuilder addServletBuilder(ServletBuilder servletBuiler) {
        this.servletBuilders.add(servletBuiler);
        return this;
    }

    public Server create() {
        if (this.port == null) {
            this.port = 7531;
        }
        GenericWebApplicationContext rootContext = new GenericWebApplicationContext();
        List initializers = this.servletBuilders.stream().map(builder -> builder.build(rootContext)).collect(Collectors.toList());
        WebApplicationInitializer initializer = servletContext -> {
            WebAppInitUtils.defaultSetup((ServletContext)servletContext, (WebApplicationContext)rootContext);
            for (WebApplicationInitializer item : initializers) {
                item.onStartup(servletContext);
            }
        };
        Server result = ServerUtils.startServer((int)this.port, (WebApplicationInitializer)initializer);
        ServerBuilder.postProcess(result);
        return result;
    }

    public static void postProcess(Server server) {
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            AbstractConnector c = (AbstractConnector)connector;
            c.setIdleTimeout(7776000L);
        }
    }

    public static ServerBuilder newBuilder() {
        return new ServerBuilder();
    }
}

