/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.server.boot;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlExecFactory;
import org.aksw.jenax.web.provider.QueryExceptionProvider;
import org.aksw.jenax.web.provider.UncaughtExceptionProvider;
import org.aksw.jenax.web.provider.UnwrapRuntimeExceptionProvider;
import org.aksw.jenax.web.server.boot.ServletBuilder;
import org.aksw.jenax.web.servlet.graphql.v1.ServletGraphQlEndpointImpl;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class ServletBuilderGraphQl
implements ServletBuilder {
    protected RdfGraphQlExecFactory graphQlExecFactory;

    public static ServletBuilderGraphQl newBuilder() {
        return new ServletBuilderGraphQl();
    }

    public RdfGraphQlExecFactory getGraphQlExecFactory() {
        return this.graphQlExecFactory;
    }

    public ServletBuilderGraphQl setGraphQlExecFactory(RdfGraphQlExecFactory graphQlExecFactory) {
        this.graphQlExecFactory = graphQlExecFactory;
        return this;
    }

    @Override
    public WebApplicationInitializer build(GenericWebApplicationContext rootContext) {
        ConfigurableListableBeanFactory beanFactory = rootContext.getBeanFactory();
        beanFactory.registerSingleton("graphQlExecFactory", (Object)this.graphQlExecFactory);
        WebApplicationInitializer result = servletContext -> {
            ServletRegistration.Dynamic servlet = servletContext.addServlet("graphqlServiceServlet", (Servlet)new ServletContainer());
            servlet.setInitParameter("jersey.config.server.provider.classnames", String.join((CharSequence)",", ServletGraphQlEndpointImpl.class.getCanonicalName(), QueryExceptionProvider.class.getCanonicalName(), UnwrapRuntimeExceptionProvider.class.getCanonicalName(), UncaughtExceptionProvider.class.getCanonicalName()));
            servlet.addMapping(new String[]{"/graphql/v1/*"});
            servlet.setAsyncSupported(true);
            servlet.setLoadOnStartup(1);
        };
        return result;
    }
}

