/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.server.boot;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.function.Function;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionModular;
import org.aksw.jenax.dataaccess.sparql.connection.query.SparqlQueryConnectionJsaBase;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.web.filter.FilterPost;
import org.aksw.jenax.web.filter.SparqlStmtTypeAcceptHeaderFilter;
import org.aksw.jenax.web.frontend.WebMvcConfigSparql;
import org.aksw.jenax.web.provider.QueryExceptionProvider;
import org.aksw.jenax.web.provider.UncaughtExceptionProvider;
import org.aksw.jenax.web.provider.UnwrapRuntimeExceptionProvider;
import org.aksw.jenax.web.server.boot.ServletBuilder;
import org.aksw.jenax.web.servlet.RdfConnectionFactory;
import org.aksw.jenax.web.servlet.ServletSparqlServiceImpl;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class ServletBuilderSparql
implements ServletBuilder {
    protected RdfConnectionFactory connectionFactory;
    protected SparqlStmtParser sparqlStmtParser;

    public static ServletBuilderSparql newBuilder() {
        return new ServletBuilderSparql();
    }

    public RdfConnectionFactory getSparqlServiceFactory() {
        return this.connectionFactory;
    }

    public ServletBuilderSparql setSparqlServiceFactory(RdfConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    public ServletBuilderSparql setSparqlServiceFactory(QueryExecutionFactoryQuery qef) {
        return this.setSparqlServiceFactory(request -> new RDFConnectionModular((SparqlQueryConnection)new SparqlQueryConnectionJsaBase(qef), null, null));
    }

    public ServletBuilderSparql setSparqlServiceFactory(RDFDataSource dataSource) {
        return this.setSparqlServiceFactory(request -> dataSource.getConnection());
    }

    public Function<String, SparqlStmt> getSparqlStmtParser() {
        return this.sparqlStmtParser;
    }

    public ServletBuilderSparql setSparqlStmtParser(SparqlStmtParser sparqlStmtParser) {
        this.sparqlStmtParser = sparqlStmtParser;
        return this;
    }

    @Override
    public WebApplicationInitializer build(GenericWebApplicationContext rootContext) {
        ConfigurableListableBeanFactory beanFactory = rootContext.getBeanFactory();
        beanFactory.registerSingleton("sparqlConnectionFactory", (Object)this.connectionFactory);
        beanFactory.registerSingleton("sparqlStmtParser", (Object)this.sparqlStmtParser);
        WebApplicationInitializer result = servletContext -> ServletBuilderSparql.initServlet(servletContext, rootContext);
        return result;
    }

    public static void initServlet(ServletContext servletContext, GenericWebApplicationContext rootContext) {
        String path = "/sparql/*";
        FilterRegistration.Dynamic fr = servletContext.addFilter("FilterPost", (Filter)new FilterPost());
        fr.addMappingForUrlPatterns(null, true, new String[]{path});
        fr.setAsyncSupported(true);
        GenericWebApplicationContext cxt = rootContext;
        SparqlStmtParser sparqlStmtParser = (SparqlStmtParser)cxt.getBeanFactory().getSingleton("sparqlStmtParser");
        FilterRegistration.Dynamic fr2 = servletContext.addFilter("SparqlStmtTypeAcceptHeaderFilter", (Filter)new SparqlStmtTypeAcceptHeaderFilter(sparqlStmtParser));
        fr2.addMappingForUrlPatterns(null, true, new String[]{path});
        fr2.setAsyncSupported(true);
        ServletRegistration.Dynamic servlet = servletContext.addServlet("sparqlServiceServlet", (Servlet)new ServletContainer());
        servlet.setInitParameter("jersey.config.server.provider.classnames", String.join((CharSequence)",", ServletSparqlServiceImpl.class.getCanonicalName(), QueryExceptionProvider.class.getCanonicalName(), UnwrapRuntimeExceptionProvider.class.getCanonicalName(), UncaughtExceptionProvider.class.getCanonicalName()));
        servlet.addMapping(new String[]{path});
        servlet.setAsyncSupported(true);
        servlet.setLoadOnStartup(1);
        AnnotationConfigWebApplicationContext dispatcherContext = new AnnotationConfigWebApplicationContext();
        dispatcherContext.register(new Class[]{WebMvcConfigSparql.class});
        ServletRegistration.Dynamic servlet2 = servletContext.addServlet("dispatcherServlet", (Servlet)new DispatcherServlet((WebApplicationContext)dispatcherContext));
        servlet2.addMapping(new String[]{"/*"});
        servlet2.setAsyncSupported(true);
        servlet2.setLoadOnStartup(1);
    }
}

