/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.server.boot;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecFactory;
import org.aksw.jenax.web.provider.QueryExceptionProvider;
import org.aksw.jenax.web.provider.UncaughtExceptionProvider;
import org.aksw.jenax.web.provider.UnwrapRuntimeExceptionProvider;
import org.aksw.jenax.web.server.boot.ServletBuilder;
import org.aksw.jenax.web.servlet.graphql.v2.ServletGraphQlEndpointImpl;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class ServletBuilderGraphQlV2
implements ServletBuilder {
    protected GraphQlExecFactory graphQlExecFactory;

    public static ServletBuilderGraphQlV2 newBuilder() {
        return new ServletBuilderGraphQlV2();
    }

    public GraphQlExecFactory getGraphQlExecFactory() {
        return this.graphQlExecFactory;
    }

    public ServletBuilderGraphQlV2 setGraphQlExecFactory(GraphQlExecFactory graphQlExecFactory) {
        this.graphQlExecFactory = graphQlExecFactory;
        return this;
    }

    @Override
    public WebApplicationInitializer build(GenericWebApplicationContext rootContext) {
        ConfigurableListableBeanFactory beanFactory = rootContext.getBeanFactory();
        beanFactory.registerSingleton("graphQlExecFactoryV2", (Object)this.graphQlExecFactory);
        WebApplicationInitializer result = servletContext -> {
            ServletRegistration.Dynamic servlet = servletContext.addServlet("graphqlServiceServletV2", (Servlet)new ServletContainer());
            servlet.setInitParameter("jersey.config.server.provider.classnames", String.join((CharSequence)",", ServletGraphQlEndpointImpl.class.getCanonicalName(), QueryExceptionProvider.class.getCanonicalName(), UnwrapRuntimeExceptionProvider.class.getCanonicalName(), UncaughtExceptionProvider.class.getCanonicalName()));
            servlet.addMapping(new String[]{"/graphql/*"});
            servlet.setAsyncSupported(true);
            servlet.setLoadOnStartup(1);
        };
        return result;
    }
}

