/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.frontend;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.EventListener;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee9.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.webapp.WebInfConfiguration;
import org.eclipse.jetty.ee9.webapp.WebXmlConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.WebApplicationInitializer;

public class ServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServerUtils.class);

    public static Server startServer(int port, WebApplicationInitializer initializer) {
        Server result = ServerUtils.startServer(ServerUtils.class, port, initializer);
        return result;
    }

    public static Server startServer(Class<?> clazz, int port, WebApplicationInitializer initializer) {
        String externalForm = ServerUtils.getExternalForm(clazz);
        Server result = ServerUtils.startServer(port, externalForm, initializer);
        return result;
    }

    public static Server startServer(int port, String externalForm, WebApplicationInitializer initializer) {
        Server server = ServerUtils.prepareServer(port, externalForm, initializer);
        try {
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public static Server prepareServer(int port, WebApplicationInitializer initializer) {
        Server result = ServerUtils.prepareServer(ServerUtils.class, port, initializer);
        return result;
    }

    public static String getExternalForm(Class<?> clazz) {
        String rawFilename;
        String filename;
        Path parent;
        Path warPath;
        Path path;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        URL location = protectionDomain.getCodeSource().getLocation();
        String externalForm = location.toExternalForm();
        if (logger.isDebugEnabled()) {
            logger.debug("Trying to resolve webapp by starting from location (external form): " + externalForm);
        }
        try {
            path = Paths.get(location.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (externalForm.endsWith("/classes/")) {
            Path webappFolder = path.resolve("../../src/main/webapp").normalize();
            if (Files.exists(webappFolder, new LinkOption[0])) {
                externalForm = webappFolder.toString();
            }
        } else if (externalForm.endsWith("-classes.jar") && Files.exists(warPath = (parent = path.getParent()).resolve(filename = (rawFilename = String.valueOf(path.getFileName())).replace("-classes.jar", ".war")), new LinkOption[0])) {
            externalForm = warPath.toString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Resolved webapp location to: " + externalForm);
        }
        return externalForm;
    }

    public static Server prepareServer(Class<?> clazz, int port, WebApplicationInitializer initializer) {
        String externalForm = ServerUtils.getExternalForm(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug("Loading webAppContext from " + externalForm);
        }
        Server result = ServerUtils.prepareServer(port, externalForm, initializer);
        return result;
    }

    public static Server prepareServer(int port, String externalForm, final WebApplicationInitializer initializer) {
        ContextHandler.APIContext servletContext;
        Server server = new Server(port);
        WebAppContext webAppContext = new WebAppContext();
        ContextHandler.APIContext api = servletContext = webAppContext.getServletContext();
        api.setExtendedListenerTypes(true);
        webAppContext.addConfiguration(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new PlusConfiguration(), new JettyWebXmlConfiguration(), new WebInfConfiguration(), new MetaInfConfiguration()});
        if (externalForm == null || !externalForm.endsWith(".war")) {
            Objects.requireNonNull(initializer, "Configuration from non-war file requires an WebAppInitializer");
            webAppContext.addEventListener((EventListener)new LifeCycle.Listener(){
                final /* synthetic */ ServletContext val$servletContext;
                {
                    this.val$servletContext = servletContext;
                }

                public void lifeCycleStarting(LifeCycle arg0) {
                    try {
                        initializer.onStartup(this.val$servletContext);
                    }
                    catch (ServletException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        webAppContext.setServer(server);
        webAppContext.setContextPath("/");
        webAppContext.setWar(externalForm);
        server.setHandler((Supplier)webAppContext);
        return server;
    }
}

