/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.servlet.graphql.v1;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStream;
import java.util.Objects;
import org.aksw.jenax.graphql.impl.common.GraphQlExecUtils;
import org.aksw.jenax.graphql.json.api.GraphQlExec;
import org.aksw.jenax.graphql.json.api.GraphQlExecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQlEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlEndpointBase.class);

    protected abstract GraphQlExecFactory getGraphQlExecFactory();

    @POST
    @Consumes
    public void execute(@Suspended AsyncResponse response, String postBody) {
        this.processQueryAsync(response, postBody);
    }

    public void processQueryAsync(AsyncResponse asyncResponse, String query) {
        GraphQlExec exec;
        try {
            GraphQlExecFactory gef = Objects.requireNonNull(this.getGraphQlExecFactory(), "GraphQlExecFactory is null");
            exec = GraphQlExecUtils.execJson((GraphQlExecFactory)gef, (String)query);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
            throw new RuntimeException(e);
        }
        asyncResponse.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                logger.debug("Client disconnected");
            }
        });
        asyncResponse.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully completed graphql query execution");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Failed graphql query execution");
                }
            }
        });
        Response response = GraphQlEndpointBase.createResponse(exec);
        asyncResponse.resume((Object)response);
    }

    public static Response createResponse(GraphQlExec ge) {
        String contentTypeStr = "application/json";
        StreamingOutput processor = out -> GraphQlExecUtils.writePretty((OutputStream)out, (GraphQlExec)ge);
        Response result = Response.ok((Object)processor, (String)contentTypeStr).build();
        return result;
    }
}

