/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.servlet;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmtOverResultFmt;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmts;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmtsUtils;
import org.aksw.jenax.arq.util.fmt.SparqlResultFmts;
import org.aksw.jenax.arq.util.fmt.SparqlResultFmtsImpl;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.stmt.core.SparqlStmtUpdate;
import org.aksw.jenax.stmt.util.SparqlStmtUtils;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparqlEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(SparqlEndpointBase.class);
    protected SparqlStmtParser defaultSparqlStmtParser = SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)true);

    protected SparqlStmtParser getSparqlStmtParser() {
        return this.defaultSparqlStmtParser;
    }

    protected abstract RDFConnection getConnection();

    protected void executeAsync(AsyncResponse asyncResponse, String acceptHeaders, String queryString, String updateString, List<String> graphIris, List<String> namedGraphIris, List<String> usingGraphIris, List<String> usingNamedGraphIris) {
        AcceptList acceptList = new AcceptList(acceptHeaders);
        SparqlResultFmts fmts = SparqlResultFmtsImpl.forContentTypes((AcceptList)acceptList);
        DatasetDescription queryDd = DatasetDescriptionUtils.ofStrings(graphIris, namedGraphIris);
        DatasetDescription updateDd = DatasetDescriptionUtils.ofStrings(usingGraphIris, usingNamedGraphIris);
        this.processStmtAsync(asyncResponse, queryString, updateString, fmts, queryDd, updateDd);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void executeWildcardPost(@Suspended AsyncResponse asyncResponse, @jakarta.ws.rs.core.Context HttpHeaders headers, @FormParam(value="query") String queryString, @FormParam(value="update") String updateStr, @FormParam(value="default-graph-uri") List<String> defaultGraphIris, @FormParam(value="named-graph-uri") List<String> namedGraphIris, @FormParam(value="using-graph-uri") List<String> usingGraphIris, @FormParam(value="using-graph-uri") List<String> usingNamedGraphIris) {
        this.executeAsync(asyncResponse, headers.getHeaderString("Accept"), queryString, updateStr, defaultGraphIris, namedGraphIris, usingGraphIris, usingNamedGraphIris);
    }

    @POST
    @Consumes(value={"application/sparql-query"})
    public void executeQueryWildcardPostDirect(@Suspended AsyncResponse asyncResponse, @jakarta.ws.rs.core.Context HttpHeaders headers, String queryString) {
        this.executeAsync(asyncResponse, headers.getHeaderString("Accept"), queryString, null, null, null, null, null);
    }

    @GET
    public void executeQueryText(@Suspended AsyncResponse asyncResponse, @jakarta.ws.rs.core.Context HttpHeaders headers, @QueryParam(value="query") String queryString, @QueryParam(value="update") String updateString, @QueryParam(value="default-graph-uri") List<String> defaultGraphIris, @QueryParam(value="named-graph-uri") List<String> namedGraphIris, @QueryParam(value="using-graph-uri") List<String> usingGraphIris, @QueryParam(value="using-named-graph-uri") List<String> usingNamedGraphIris) {
        this.executeAsync(asyncResponse, headers.getHeaderString("Accept"), queryString, updateString, defaultGraphIris, namedGraphIris, usingGraphIris, usingNamedGraphIris);
    }

    @POST
    @Consumes(value={"application/sparql-update"})
    public void executeUpdatePost(@Suspended AsyncResponse asyncResponse, @jakarta.ws.rs.core.Context HttpHeaders headers, String updateString) {
        this.executeAsync(asyncResponse, headers.getHeaderString("Accept"), null, updateString, null, null, null, null);
    }

    public void processStmtAsync(AsyncResponse response, String queryStr, String updateStr, SparqlResultFmts format, DatasetDescription queryDd, DatasetDescription updateDd) {
        if (queryStr == null && updateStr == null) {
            throw new QueryException("No query/update statement provided");
        }
        if (queryStr != null && updateStr != null && !updateStr.equals(queryStr)) {
            throw new QueryException(String.format("Both 'query' and 'update' statement strings provided in a single request; query=%s update=%s", queryStr, updateStr));
        }
        String stmtStr = queryStr != null ? queryStr : updateStr;
        SparqlStmtParser sparqlStmtParser = this.getSparqlStmtParser();
        SparqlStmt stmt = (SparqlStmt)sparqlStmtParser.apply((Object)stmtStr);
        if (stmt.isParsed()) {
            if (stmt.isQuery()) {
                SparqlStmtUtils.overwriteDatasetDescription((SparqlStmt)stmt, (DatasetDescription)queryDd);
            } else if (stmt.isUpdateRequest()) {
                SparqlStmtUtils.overwriteDatasetDescription((SparqlStmt)stmt, (DatasetDescription)updateDd);
            }
        }
        if (stmt.isQuery()) {
            this.processQueryAsync(response, stmt.getAsQueryStmt(), format);
        } else if (stmt.isUpdateRequest()) {
            this.processUpdateAsync(response, stmt.getAsUpdateStmt());
        } else {
            throw new RuntimeException("Unknown request type: " + queryStr);
        }
    }

    public void processQueryAsync(AsyncResponse response, SparqlStmtQuery stmt, SparqlResultFmts format) {
        final Object abortLock = new Object();
        final boolean[] isAborted = new boolean[]{false};
        final QueryExecution[] activeQe = new QueryExecution[]{null};
        Consumer<QueryExecution> qeCallback = qe -> {
            Object object = abortLock;
            synchronized (object) {
                activeQe[0] = qe;
                if (isAborted[0]) {
                    qe.abort();
                }
            }
        };
        response.register((Object)new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDisconnect(AsyncResponse disconnect) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Client disconnected");
                }
                Object object = abortLock;
                synchronized (object) {
                    isAborted[0] = true;
                    QueryExecution qe = activeQe[0];
                    if (qe != null) {
                        qe.abort();
                    }
                }
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully completed query execution");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Failed query execution");
                }
            }
        });
        RDFDataSource dataSource = () -> this.getConnection();
        QueryExecutionFactory qef = dataSource.asQef();
        Response x = this.processQuery(qef, stmt, format, qeCallback);
        response.resume((Object)x);
    }

    public static QueryExecution exec(QueryExecutionFactory qef, SparqlStmtQuery stmt) {
        QueryExecution result;
        if (stmt.isParsed()) {
            Query query = stmt.getQuery();
            result = qef.createQueryExecution(query);
        } else {
            String queryStr = stmt.getOriginalString();
            result = qef.createQueryExecution(queryStr);
        }
        return result;
    }

    public static Consumer<OutputStream> createQueryProcessor(QueryExecutionFactory qef, SparqlStmtQuery stmt, Lang lang, RDFFormat fmt, Context riotCxt, Consumer<QueryExecution> qeCallback) {
        Query parsedQuery;
        Consumer<OutputStream> result = null;
        ResultSetWriterFactory rswf = lang != null ? ResultSetWriterRegistry.getFactory((Lang)lang) : null;
        Query query = parsedQuery = stmt.isParsed() ? stmt.getQuery() : null;
        if (rswf != null) {
            result = out -> {
                try (QueryExecution qe = SparqlEndpointBase.exec(qef, stmt);){
                    qeCallback.accept(qe);
                    ResultSetWriter rsWriter = rswf.create(lang);
                    Objects.requireNonNull(rsWriter);
                    if (parsedQuery.isAskType()) {
                        boolean v = qe.execAsk();
                        rsWriter.write(out, v, riotCxt);
                    } else if (parsedQuery.isJsonType()) {
                        ResultSetFormatter.output((OutputStream)out, (Iterator)qe.execJsonItems());
                    } else {
                        rsWriter.write(out, qe.execSelect(), riotCxt);
                    }
                }
            };
        } else if (fmt != null) {
            if (StreamRDFWriter.registered((RDFFormat)fmt)) {
                result = out -> {
                    StreamRDF writer = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)fmt, (Context)riotCxt);
                    Objects.requireNonNull(writer);
                    writer.start();
                    try (QueryExecution qe = SparqlEndpointBase.exec(qef, stmt);){
                        qeCallback.accept(qe);
                        if (parsedQuery.isConstructType()) {
                            if (parsedQuery.isConstructQuad()) {
                                StreamRDFOps.sendQuadsToStream((Iterator)qe.execConstructQuads(), (StreamRDF)writer);
                            } else {
                                StreamRDFOps.sendTriplesToStream((Iterator)qe.execConstructTriples(), (StreamRDF)writer);
                            }
                        } else if (parsedQuery.isDescribeType()) {
                            StreamRDFOps.sendTriplesToStream((Iterator)qe.execDescribeTriples(), (StreamRDF)writer);
                        } else {
                            throw new RuntimeException("Unknown query type: " + String.valueOf(parsedQuery));
                        }
                        writer.finish();
                    }
                };
            } else if (RDFWriterRegistry.contains((Lang)lang)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Warning! Running non-streaming RDF writer " + fmt.toString() + " and building in-memory model");
                }
                result = out -> {
                    try (QueryExecution qe = SparqlEndpointBase.exec(qef, stmt);){
                        qeCallback.accept(qe);
                        RDFWriterBuilder writerBuilder = RDFWriter.create();
                        if (parsedQuery.isConstructType()) {
                            if (parsedQuery.isConstructQuad()) {
                                DatasetGraph dsg = DatasetGraphFactory.createGeneral();
                                qe.execConstructQuads().forEachRemaining(arg_0 -> ((DatasetGraph)dsg).add(arg_0));
                                writerBuilder.source(dsg);
                            } else {
                                Graph graph = GraphFactory.createPlainGraph();
                                qe.execConstructTriples().forEachRemaining(arg_0 -> ((Graph)graph).add(arg_0));
                                writerBuilder.source(graph);
                            }
                        } else if (parsedQuery.isDescribeType()) {
                            Graph graph = GraphFactory.createPlainGraph();
                            qe.execDescribeTriples().forEachRemaining(arg_0 -> ((Graph)graph).add(arg_0));
                            writerBuilder.source(graph);
                        } else {
                            throw new RuntimeException("Unknown query type: " + String.valueOf(parsedQuery));
                        }
                        writerBuilder.format(fmt).context(riotCxt).output(out);
                    }
                };
            } else {
                throw new RuntimeException("Could not handle execution of query " + String.valueOf(stmt) + " with lang " + String.valueOf(lang));
            }
        }
        return result;
    }

    public Response processQuery(QueryExecutionFactory qef, SparqlStmtQuery stmt, SparqlResultFmts format, Consumer<QueryExecution> qeCallback) {
        Lang lang = null;
        RDFFormat rdfFormat = null;
        Query query = stmt.getQuery();
        if (query != null) {
            SparqlQueryFmtOverResultFmt fmts = new SparqlQueryFmtOverResultFmt(format);
            lang = SparqlQueryFmtsUtils.getLang((SparqlQueryFmts)fmts, (Query)query);
            rdfFormat = SparqlQueryFmtsUtils.getRdfFormat((SparqlQueryFmts)fmts, (Query)query);
        }
        if (lang == null) {
            throw new RuntimeException("Parse error: ", (Throwable)stmt.getParseException());
        }
        String contentTypeStr = lang.getContentType().getContentTypeStr();
        StreamingOutput processor = SparqlEndpointBase.createQueryProcessor(qef, stmt, lang, rdfFormat, Context.create(), qeCallback)::accept;
        Response result = Response.ok((Object)processor, (String)contentTypeStr).build();
        return result;
    }

    public UpdateProcessor createUpdateProcessor(SparqlStmtUpdate stmt) {
        throw new UnsupportedOperationException("The method for handling SPARQL update requests has not been overridden");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdateAsync(AsyncResponse response, SparqlStmtUpdate stmt) {
        final RDFConnection conn = this.getConnection();
        response.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                conn.abort();
                if (logger.isDebugEnabled()) {
                    logger.debug("Client disconnected");
                }
            }
        });
        response.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully completed query execution");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Failed query execution");
                }
            }
        });
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Opened connection: " + System.identityHashCode(conn));
            }
            if (stmt.isParsed()) {
                conn.update(stmt.getUpdateRequest());
            } else {
                conn.update(stmt.getOriginalString());
            }
            String result = "{\"success\": true}";
            response.resume((Object)result);
        }
        catch (Exception e) {
            response.resume((Throwable)e);
        }
        finally {
            conn.close();
        }
    }
}

