/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.filter;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;

public class RepeatablePayloadReadWrapper
extends HttpServletRequestWrapper {
    protected Charset charset;
    protected Callable<InputStream> inputStreamSupplier;

    public RepeatablePayloadReadWrapper(HttpServletRequest request, Charset charset, Callable<InputStream> inputStreamSupplier) {
        super(request);
        this.charset = charset;
        this.inputStreamSupplier = inputStreamSupplier;
    }

    public ServletInputStream getInputStream() throws IOException {
        InputStream raw;
        try {
            raw = this.inputStreamSupplier.call();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new ServletInputStream(){
            protected ReadListener readListener = null;
            protected boolean isFinished;

            public int read() throws IOException {
                int result = raw.read();
                this.isFinished = result == -1;
                return result;
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return this.isFinished;
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.charset));
    }
}

