/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.filter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;

public class HeaderMapRequestWrapper
extends HttpServletRequestWrapper {
    protected boolean overrideValuesMode;
    protected ListMultimap<String, String> headerMap = ArrayListMultimap.create();

    public HeaderMapRequestWrapper(HttpServletRequest request, boolean overrideMode) {
        super(request);
        this.overrideValuesMode = overrideMode;
    }

    public void addHeader(String name, String value) {
        this.headerMap.put((Object)name, (Object)value);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if ((this.overrideValuesMode || headerValue == null) && this.headerMap.containsKey((Object)name)) {
            headerValue = (String)Iterables.getFirst((Iterable)this.headerMap.get((Object)name), null);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        LinkedHashSet names = new LinkedHashSet(Collections.list(super.getHeaderNames()));
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        List<Object> values;
        List tmp = this.headerMap.get((Object)name);
        if (this.overrideValuesMode && this.headerMap.containsKey((Object)name)) {
            values = tmp;
        } else {
            values = Collections.list(super.getHeaders(name));
            values.addAll(tmp);
        }
        return Collections.enumeration(values);
    }
}

