/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import java.util.EventListener;
import org.aksw.jenax.web.filter.CorsFilter;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;

public class WebAppInitUtils {
    public static void defaultSetup(ServletContext servletContext, Class<?> appConfig) {
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.register(new Class[]{appConfig});
        WebAppInitUtils.defaultSetup(servletContext, (WebApplicationContext)rootContext);
    }

    public static void defaultSetup(ServletContext servletContext, WebApplicationContext rootContext) {
        servletContext.addListener((EventListener)new ContextLoaderListener(rootContext));
        servletContext.addListener((EventListener)new RequestContextListener());
        FilterRegistration.Dynamic fr = servletContext.addFilter("CharacterEncodingFilter", (Filter)new CharacterEncodingFilter());
        fr.setInitParameter("encoding", "UTF-8");
        fr.setInitParameter("forceEncoding", "true");
        fr.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        fr.setAsyncSupported(true);
        fr = servletContext.addFilter("CorsFilter", (Filter)new CorsFilter());
        fr.addMappingForUrlPatterns(null, true, new String[]{"/*"});
        fr.setAsyncSupported(true);
    }
}

