/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmtOverResultFmt;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmts;
import org.aksw.jenax.arq.util.fmt.SparqlQueryFmtsUtils;
import org.aksw.jenax.arq.util.fmt.SparqlResultFmtsImpl;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParser;
import org.aksw.jenax.web.filter.DEF;
import org.aksw.jenax.web.filter.HeaderMapRequestWrapper;
import org.aksw.jenax.web.filter.RepeatablePayloadReadWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.query.Query;
import org.apache.jena.riot.Lang;

@WebFilter
public class SparqlStmtTypeAcceptHeaderFilter
implements Filter {
    protected SparqlStmtParser sparqlStmtParser;

    public SparqlStmtTypeAcceptHeaderFilter(SparqlStmtParser sparqlStmtParser) {
        this.sparqlStmtParser = sparqlStmtParser;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String payload = null;
        Enumeration it = req.getHeaders("Accept");
        boolean isWildcard = true;
        boolean isSparqlRequest = false;
        MediaType type = null;
        while (it.hasMoreElements()) {
            String item = (String)it.nextElement();
            if (!item.equals("*/*")) {
                isWildcard = false;
            }
            if (isSparqlRequest || DEF.constructOffer.match(type = MediaType.createFromContentType((String)item)) == null && DEF.quadsOffer.match(type) == null && DEF.rdfOffer.match(type) == null && DEF.rsOfferTable.match(type) == null && DEF.rsOfferBoolean.match(type) == null) continue;
            isSparqlRequest = true;
        }
        if (isWildcard || isSparqlRequest) {
            String acceptTypeStr;
            boolean isSparqlPayload;
            ArrayList<String> strs = new ArrayList<String>();
            String contentTypeStr = req.getContentType();
            boolean bl = isSparqlPayload = "application/sparql-query".equals(contentTypeStr) || "application/sparql-update".equals(contentTypeStr);
            if (isSparqlPayload) {
                isSparqlRequest = true;
                try (ServletInputStream in = req.getInputStream();){
                    payload = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                }
                strs.add(payload);
            } else {
                Map params = req.getParameterMap();
                List queryValues = Optional.ofNullable((String[])params.get("query")).map(Arrays::asList).orElse(Collections.emptyList());
                List updateValues = Optional.ofNullable((String[])params.get("update")).map(Arrays::asList).orElse(Collections.emptyList());
                strs.addAll(queryValues);
                strs.addAll(updateValues);
                isSparqlRequest = !strs.isEmpty();
            }
            String string = acceptTypeStr = type != null ? type.toHeaderString() : null;
            if (isSparqlRequest) {
                SparqlStmt stmt;
                String str;
                SparqlQueryFmtOverResultFmt fmts = new SparqlQueryFmtOverResultFmt(SparqlResultFmtsImpl.DEFAULT);
                String string2 = str = strs.size() == 1 ? (String)strs.iterator().next() : null;
                if (str != null && (acceptTypeStr == null || isWildcard) && (stmt = (SparqlStmt)this.sparqlStmtParser.apply((Object)str)).isParsed() && stmt.isQuery()) {
                    Lang lang = SparqlQueryFmtsUtils.getLang((SparqlQueryFmts)fmts, (Query)stmt.getQuery());
                    acceptTypeStr = lang.getContentType().getContentTypeStr();
                }
            }
            if (acceptTypeStr == null || isWildcard) {
                acceptTypeStr = "application/json";
            }
            HeaderMapRequestWrapper tmp = new HeaderMapRequestWrapper((HttpServletRequest)req, true);
            tmp.addHeader("Accept", acceptTypeStr);
            req = tmp;
        }
        if (payload != null) {
            byte[] bytes = payload.getBytes();
            req = new RepeatablePayloadReadWrapper((HttpServletRequest)req, StandardCharsets.UTF_8, () -> new ByteArrayInputStream(bytes));
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

