/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.web.servlet.graphql.v2;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStream;
import java.util.Objects;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecBuilder;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecFactory;
import org.aksw.jenax.graphql.sparql.v2.exec.api.high.GraphQlExecUtils;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessorSettings;
import org.aksw.jenax.graphql.sparql.v2.io.GraphQlJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQlEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlEndpointBase.class);

    protected abstract GraphQlExecFactory getGraphQlExecFactory();

    @POST
    @Consumes
    public void execute(@Suspended AsyncResponse response, String postBody) {
        this.processQueryAsync(response, postBody);
    }

    public void processQueryAsync(AsyncResponse asyncResponse, String query) {
        GraphQlExec exec;
        try {
            GraphQlExecFactory factory = Objects.requireNonNull(this.getGraphQlExecFactory(), "GraphQlProcessorFactory is null");
            GraphQlExecBuilder builder = factory.newBuilder();
            GraphQlJsonUtils.configureFromJson((GraphQlProcessorSettings)builder, (String)query);
            exec = builder.buildForJson();
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
            throw new RuntimeException(e);
        }
        asyncResponse.register((Object)new ConnectionCallback(){

            public void onDisconnect(AsyncResponse disconnect) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Client disconnected");
                }
            }
        });
        asyncResponse.register((Object)new CompletionCallback(){

            public void onComplete(Throwable t) {
                if (t == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully completed graphql query execution");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Failed graphql query execution");
                }
            }
        });
        Response response = GraphQlEndpointBase.createResponse((GraphQlExec<String>)exec);
        asyncResponse.resume((Object)response);
    }

    public static Response createResponse(GraphQlExec<String> ge) {
        String contentTypeStr = "application/json";
        StreamingOutput processor = out -> GraphQlExecUtils.write((OutputStream)out, (GraphQlExec)ge);
        Response result = Response.ok((Object)processor, (String)contentTypeStr).build();
        return result;
    }
}

