/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.dataset;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.io.syscall.SysCalls;
import org.aksw.commons.io.syscall.sort.SysSort;
import org.aksw.commons.rx.function.RxFunction;
import org.aksw.commons.rx.op.RxOps;
import org.aksw.jena_sparql_api.io.json.TypeAdapterDataset;
import org.aksw.jena_sparql_api.io.json.TypeAdapterNode;
import org.aksw.jena_sparql_api.rx.dataset.FlowableOps;
import org.aksw.jena_sparql_api.rx.dataset.ResourceInDatasetFlowOps;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessor;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExProcessorBuilder;
import org.aksw.jena_sparql_api.rx.io.resultset.SPARQLResultExVisitor;
import org.aksw.jena_sparql_api.rx.io.resultset.SparqlMappers;
import org.aksw.jenax.arq.dataset.orderaware.DatasetFactoryEx;
import org.aksw.jenax.arq.util.query.CannedQueryUtils;
import org.aksw.jenax.sparql.rx.op.FlowOfDatasetOps;
import org.aksw.jenax.sparql.rx.op.FlowOfQuadsOps;
import org.aksw.jenax.sparql.rx.op.ResultSetMappers;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParser;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.Context;

public class DatasetFlowOps {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Node.class, (Object)new TypeAdapterNode()).registerTypeHierarchyAdapter(Dataset.class, (Object)new TypeAdapterDataset(DatasetFactoryEx::createInsertOrderPreservingDataset)).create();

    public static String serializeForSort(Gson gson, Node key, Object data) {
        String keyStr = key.isURI() ? key.getURI() : key.getLiteralValue().toString();
        String dataStr = gson.toJson(data);
        String result = StringEscapeUtils.escapeJava((String)keyStr) + " \t" + StringEscapeUtils.escapeJava((String)dataStr);
        return result;
    }

    public static <T> T deserializeFromSort(Gson gson, String line, Class<T> clazz) {
        int idx = line.indexOf(9);
        String encoded = line.substring(idx + 1);
        String decoded = StringEscapeUtils.unescapeJava((String)encoded);
        Object result = gson.fromJson(decoded, clazz);
        return (T)result;
    }

    public static FlowableTransformer<Dataset, Dataset> createSystemSorter(SysSort cmdSort, SparqlQueryParser keyQueryParser) {
        String keyArg = cmdSort.key;
        Function<? super SparqlQueryConnection, Node> keyMapper = ResourceInDatasetFlowOps.createKeyMapper(keyArg, (Function<? super String, ? extends Query>)keyQueryParser, CannedQueryUtils.DISTINCT_NAMED_GRAPHS);
        List sortArgs = SysCalls.createDefaultSortSysCall((SysSort)cmdSort);
        FlowableTransformer sorter = DatasetFlowOps.sysCallSort(keyMapper, sortArgs);
        FlowableTransformer result = !cmdSort.merge ? sorter : upstream -> upstream.compose(sorter).compose(s -> DatasetFlowOps.mergeConsecutiveDatasets((Flowable<Dataset>)s));
        return result;
    }

    public static FlowableTransformer<Dataset, Dataset> sysCallSort(Function<? super SparqlQueryConnection, Node> keyMapper, List<String> sysCallArgs) {
        return DatasetFlowOps.sysCallSortCore(ResultSetMappers.wrapForDataset(keyMapper), sysCallArgs, (key, data) -> DatasetFlowOps.serializeForSort(GSON, key, data), line -> DatasetFlowOps.deserializeFromSort(GSON, line, Dataset.class));
    }

    public static Flowable<Dataset> mergeConsecutiveDatasets(Flowable<Dataset> in) {
        return in.compose((FlowableTransformer)RxFunction.from(FlowOfDatasetOps::flatMapToQuads).andThen(FlowOfQuadsOps.datasetsFromConsecutiveQuads(DatasetGraphFactory::create)));
    }

    public static <T, K> FlowableTransformer<T, T> sysCallSortCore(Function<T, K> keyMapper, List<String> sysCallArgs, BiFunction<K, T, String> serializer, Function<String, T> deserializer) {
        return flow -> {
            Flowable r = flow.map(ds -> {
                Object key = keyMapper.apply(ds);
                return Maps.immutableEntry(key, (Object)ds);
            }).map(e -> (String)serializer.apply(e.getKey(), e.getValue())).compose(FlowableOps.sysCall(sysCallArgs)).map(str -> deserializer.apply((String)str));
            return r;
        };
    }

    public static <I, O, V1, V2> Function<I, O> createItemMapper(Function<? super V1, ? extends V2> valueMapper, Function<? super I, ? extends V1> getter, BiFunction<? super I, ? super V2, O> setter) {
        return item -> {
            Object before = getter.apply((Object)item);
            Object after = valueMapper.apply((Object)before);
            Object r = setter.apply((Object)item, (Object)after);
            return r;
        };
    }

    public static <I, O, V1, V2> Function<I, List<O>> createItemMultiMapper(Function<? super V1, ? extends Iterable<? extends V2>> valueMapper, Function<? super I, ? extends V1> getter, BiFunction<? super I, ? super V2, O> setter) {
        return item -> {
            Object before = getter.apply((Object)item);
            Iterable after = (Iterable)valueMapper.apply((Object)before);
            List r = Streams.stream((Iterable)after).map(val -> setter.apply((Object)item, (Object)val)).collect(Collectors.toList());
            return r;
        };
    }

    public static <T, X> FlowableTransformer<T, X> createMapperDataset(Collection<? extends SparqlStmt> sparqlStmts, Function<? super T, ? extends Dataset> getDataset, BiFunction<? super T, ? super Dataset, X> setDataset, Supplier<? extends DatasetGraph> datasetGraphSupplier, Consumer<Context> contextHandler) {
        SPARQLResultExProcessor resultProcessor = SPARQLResultExProcessorBuilder.createForQuadOutput().build();
        Function connectionBasedMapper = SparqlMappers.createMapperDataset(sparqlStmts, (SPARQLResultExVisitor)resultProcessor, datasetGraphSupplier);
        Function datasetBasedMapper = SparqlMappers.mapDatasetToConnection((Function)connectionBasedMapper);
        Function<? super T, List<X>> itemMapper = DatasetFlowOps.createItemMultiMapper(datasetBasedMapper, getDataset, setDataset);
        return RxOps.createParallelFlatMapperOrdered(itemMapper);
    }
}

