/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.function.Function;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.FluentFnBase;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactoryFn;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.update.DatasetListenable;
import org.aksw.jena_sparql_api.update.FluentUpdateExecutionFactoryFn;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserStmt;
import org.aksw.jenax.stmt.parser.update.SparqlUpdateParserStmt;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.update.UpdateRequest;

public class FluentSparqlServiceFn<P>
extends FluentFnBase<SparqlService, P> {
    public FluentSparqlServiceFn() {
        super(false);
    }

    public FluentQueryExecutionFactoryFn<FluentSparqlServiceFn<P>> configQuery() {
        final FluentSparqlServiceFn self = this;
        final FluentQueryExecutionFactoryFn<FluentSparqlServiceFn<P>> result = new FluentQueryExecutionFactoryFn<FluentSparqlServiceFn<P>>();
        result.setParentSupplier(new Supplier<FluentSparqlServiceFn<P>>(){

            public FluentSparqlServiceFn<P> get() {
                Object fn = result.value();
                FluentSparqlServiceFn.this.compose(new Function<SparqlService, SparqlService>(){
                    final /* synthetic */ Function val$fn;
                    {
                        this.val$fn = function;
                    }

                    @Override
                    public SparqlService apply(SparqlService sparqlService) {
                        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
                        UpdateExecutionFactory uef = sparqlService.getUpdateExecutionFactory();
                        qef = (QueryExecutionFactory)this.val$fn.apply(qef);
                        String serviceUri = sparqlService.getServiceUri();
                        DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
                        SparqlServiceImpl r = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
                        return r;
                    }
                });
                return self;
            }
        });
        return result;
    }

    public FluentUpdateExecutionFactoryFn<FluentSparqlServiceFn<P>> configUpdate() {
        final FluentSparqlServiceFn self = this;
        final FluentUpdateExecutionFactoryFn<FluentSparqlServiceFn<P>> result = new FluentUpdateExecutionFactoryFn<FluentSparqlServiceFn<P>>();
        result.setParentSupplier(new Supplier<FluentSparqlServiceFn<P>>(){

            public FluentSparqlServiceFn<P> get() {
                Object fn = result.value();
                FluentSparqlServiceFn.this.compose(new Function<SparqlService, SparqlService>(){
                    final /* synthetic */ Function val$fn;
                    {
                        this.val$fn = function;
                    }

                    @Override
                    public SparqlService apply(SparqlService sparqlService) {
                        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
                        UpdateExecutionFactory uef = sparqlService.getUpdateExecutionFactory();
                        uef = (UpdateExecutionFactory)this.val$fn.apply(uef);
                        String serviceUri = sparqlService.getServiceUri();
                        DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
                        SparqlServiceImpl r = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
                        return r;
                    }
                });
                return self;
            }
        });
        return result;
    }

    public <T extends UpdateExecutionFactory & DatasetListenable> FluentSparqlServiceFn<P> withUpdateListeners(final Function<SparqlService, T> updateStrategy, final Collection<DatasetListener> listeners) {
        this.compose(new Function<SparqlService, SparqlService>(){

            @Override
            public SparqlService apply(SparqlService sparqlService) {
                QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
                UpdateExecutionFactory uef = (UpdateExecutionFactory)updateStrategy.apply(sparqlService);
                ((DatasetListenable)uef).getDatasetListeners().addAll(listeners);
                String serviceUri = sparqlService.getServiceUri();
                DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
                SparqlServiceImpl r = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
                return r;
            }
        });
        return this;
    }

    public FluentSparqlServiceFn<P> withDatasetDescription(DatasetDescription datasetDescription) {
        String withIri = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        if (withIri == null) {
            throw new RuntimeException("Can only derive a withIri if there is exactly one default graph; got: " + DatasetDescriptionUtils.toString((DatasetDescription)datasetDescription));
        }
        FluentSparqlServiceFn<P> result = this.withDatasetDescription(datasetDescription, withIri);
        return result;
    }

    public FluentSparqlServiceFn<P> withParser(Function<String, SparqlStmt> parser) {
        ((FluentSparqlServiceFn)this.configQuery().withParser((Function<String, Query>)SparqlQueryParserStmt.wrap(parser)).end()).configUpdate().withParser((Function<String, UpdateRequest>)SparqlUpdateParserStmt.wrap(parser)).end();
        return this;
    }

    public FluentSparqlServiceFn<P> withDatasetDescription(final DatasetDescription datasetDescription, String withIri) {
        ((FluentSparqlServiceFn)((FluentSparqlServiceFn)this.configQuery().withDatasetDescription(datasetDescription).end()).configUpdate().withDatasetDescription(withIri, datasetDescription).end()).compose(new Function<SparqlService, SparqlService>(){

            @Override
            public SparqlService apply(SparqlService ss) {
                SparqlServiceImpl r = new SparqlServiceImpl(ss.getServiceUri(), datasetDescription, ss.getQueryExecutionFactory(), ss.getUpdateExecutionFactory());
                return r;
            }
        });
        return this;
    }

    public static FluentSparqlServiceFn<?> start() {
        return new FluentSparqlServiceFn();
    }
}

