/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import org.aksw.commons.rx.lookup.MapPaginator;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementSubQuery;

public class MapPaginatorConcept
implements MapPaginator<Node, Node> {
    protected QueryExecutionFactory qef;
    protected Fragment1 concept;

    public MapPaginatorConcept(QueryExecutionFactory qef, Fragment1 concept) {
        this.qef = qef;
        this.concept = concept;
    }

    public static Query createSubQuery(Query query, Var var) {
        ElementSubQuery esq = new ElementSubQuery(query);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(var);
        result.setQueryPattern((Element)esq);
        return result;
    }

    @Deprecated
    public static Query createQueryCount(Fragment1 concept, Long itemLimit, Long rowLimit, Var resultVar) {
        Query subQuery = concept.asQuery();
        if (rowLimit != null) {
            subQuery.setDistinct(false);
            subQuery.setLimit(rowLimit.longValue());
            subQuery = MapPaginatorConcept.createSubQuery(subQuery, concept.getVar());
            subQuery.setDistinct(true);
        }
        if (itemLimit != null) {
            subQuery.setLimit(itemLimit.longValue());
        }
        ElementSubQuery esq = new ElementSubQuery(subQuery);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(resultVar, (Expr)new ExprAggregator(concept.getVar(), (Aggregator)new AggCount()));
        result.setQueryPattern((Element)esq);
        return result;
    }

    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        Long limit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        Query baseQuery = this.concept.toQuery();
        baseQuery.setDistinct(true);
        Map.Entry e = QueryGenerationUtils.createQueryCount((Query)baseQuery, (Long)limit, (Long)rowLimit);
        Var countVar = (Var)e.getKey();
        Query query = (Query)e.getValue();
        Single result = SparqlRx.execSelectRaw(() -> this.qef.createQueryExecution(query)).map(b -> {
            Node countNode = b.get(countVar);
            Number n = NodeUtils.getNumber((Node)countNode);
            long count = n.longValue();
            boolean hasMoreItems = false;
            if (itemLimit != null && count > itemLimit) {
                count = itemLimit;
                hasMoreItems = true;
            }
            Range r = hasMoreItems ? Range.atLeast((Comparable)itemLimit) : Range.singleton((Comparable)Long.valueOf(count));
            return r;
        }).singleOrError();
        return result;
    }

    public Flowable<Map.Entry<Node, Node>> apply(Range<Long> range) {
        Query query = this.concept.asQuery();
        QueryUtils.applyRange((Query)query, range);
        return SparqlRx.execSelectRaw(() -> this.qef.createQueryExecution(query)).map(b -> b.get((Var)b.vars().next())).map(node -> Maps.immutableEntry((Object)node, (Object)node));
    }
}

