/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.timeout;

import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.core.Time;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryDecorator;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionFactoryTimeout
extends QueryExecutionFactoryDecorator {
    private Time maxExecutionTime = null;
    private Time maxRetrievalTime = null;

    public static QueryExecutionFactoryTimeout decorate(QueryExecutionFactory decoratee, long timeout) {
        return new QueryExecutionFactoryTimeout(decoratee, timeout);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee) {
        super(decoratee);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout) {
        this(decoratee, timeout, TimeUnit.MILLISECONDS);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout, TimeUnit timeUnit) {
        super(decoratee);
        this.maxExecutionTime = new Time(timeout, timeUnit);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout1, long timeout2) {
        this(decoratee, timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
    }

    public QueryExecutionFactoryTimeout(QueryExecutionFactory decoratee, long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        super(decoratee);
        this.maxExecutionTime = new Time(timeout1, timeUnit1);
        this.maxRetrievalTime = new Time(timeout2, timeUnit2);
    }

    private void configureWithTimeout(QueryExecution qe) {
        if (this.maxExecutionTime == null || this.maxRetrievalTime != null) {
            // empty if block
        }
    }

    public QueryExecution createQueryExecution(Query query) {
        QueryExecution result = super.createQueryExecution(query);
        this.configureWithTimeout(result);
        return result;
    }

    public QueryExecution createQueryExecution(String queryString) {
        QueryExecution result = super.createQueryExecution(queryString);
        this.configureWithTimeout(result);
        return result;
    }
}

