/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.advanced;

import com.esotericsoftware.kryo.pool.KryoPool;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Range;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.reactivex.rxjava3.core.Flowable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfigImpl;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceWithPagesSyncToDisk;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.rx.cache.range.ListPaginatorWithAdvancedCache;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.store.object.key.api.ObjectStore;
import org.aksw.commons.store.object.key.impl.KryoUtils;
import org.aksw.commons.store.object.key.impl.ObjectStoreImpl;
import org.aksw.commons.store.object.path.api.ObjectSerializer;
import org.aksw.commons.store.object.path.impl.ObjectSerializerKryo;
import org.aksw.jena_sparql_api.cache.advanced.QueryExecFactoryQueryRangeCache;
import org.aksw.jena_sparql_api.lookup.ListPaginatorSparql;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.syntax.QueryHash;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalMultiplex;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapperTxn;
import org.aksw.jenax.dataaccess.sparql.exec.update.UpdateExecWrapperTxn;
import org.aksw.jenax.dataaccess.sparql.link.dataset.LinkDatasetGraphWrapperTxn;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryBase;
import org.aksw.jenax.dataaccess.sparql.link.update.LinkSparqlUpdateBase;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceWrapperBase;
import org.aksw.jenax.io.kryo.jena.JenaKryoRegistratorLib;
import org.aksw.jenax.sparql.query.rx.ResultSetRxImpl;
import org.apache.jena.query.Query;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkModular;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFLinkSourceWithRangeCache
extends RDFLinkSourceWrapperBase<RDFLinkSource> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecFactoryQueryRangeCache.class);
    protected HashCode datasetHash;
    protected static HashFunction stmtHashFn = Hashing.md5();
    protected Transactional transactional = TransactionalLock.createMRSW();
    protected ObjectStore objectStore;
    protected AdvancedRangeCacheConfig cacheConfig;
    protected ArrayOps<Binding[]> arrayOps = ArrayOps.createFor(Binding.class);
    protected Cache<org.aksw.commons.path.core.Path<String>, ListPaginator<Binding>> queryToCache;

    public RDFLinkSourceWithRangeCache(RDFLinkSource delegate, ObjectStore objectStore, HashCode datasetHash, int maxCachedQueries, AdvancedRangeCacheConfig cacheConfig) {
        super(delegate);
        this.objectStore = objectStore;
        this.cacheConfig = cacheConfig;
        this.datasetHash = datasetHash;
        this.queryToCache = CacheBuilder.newBuilder().maximumSize((long)maxCachedQueries).build();
    }

    public RDFLink newLink() {
        final RDFLink baseLink = this.getDelegate().newLink();
        TransactionalMultiplex combined = new TransactionalMultiplex(new Transactional[]{this.transactional, baseLink});
        LinkSparqlQueryBase linkQuery = new LinkSparqlQueryBase(){

            public QueryExecBuilder newQuery() {
                return new QueryExecBuilderCustomBase<QueryExecBuilder>(){

                    public QueryExec build() {
                        QueryExec r = RDFLinkSourceWithRangeCache.this.createQueryExec(this);
                        return r;
                    }
                };
            }

            public Transactional getDelegate() {
                return RDFLinkSourceWithRangeCache.this.transactional;
            }

            public void close() {
                baseLink.close();
            }
        };
        LinkSparqlUpdateBase linkUpdate = new LinkSparqlUpdateBase(){
            final /* synthetic */ Transactional val$combined;
            {
                this.val$combined = transactional;
            }

            public UpdateExecBuilder newUpdate() {
                return new UpdateExecBuilderCustomBase<UpdateExecBuilder>(){

                    public UpdateExec build() {
                        return RDFLinkSourceWithRangeCache.this.createUpdateExec((LinkSparqlUpdate)baseLink, this);
                    }
                };
            }

            public Transactional getDelegate() {
                return this.val$combined;
            }

            public void close() {
                baseLink.close();
            }
        };
        RDFLinkModular link = new RDFLinkModular((LinkSparqlQuery)linkQuery, (LinkSparqlUpdate)linkUpdate, (LinkDatasetGraph)new LinkDatasetGraphWrapperTxn((LinkDatasetGraph)baseLink, (Transactional)combined));
        return link;
    }

    public QueryExec createQueryExec(QueryExecBuilderCustomBase<?> builder) {
        ListPaginator frontend;
        Query query = builder.getParsedQuery();
        Range requestRange = QueryUtils.toRange((Query)query);
        Query bodyQueryWithoutSlice = QueryTransformOps.shallowCopy((Query)query);
        bodyQueryWithoutSlice.setOffset(Long.MIN_VALUE);
        bodyQueryWithoutSlice.setLimit(Long.MIN_VALUE);
        QueryHash hash = QueryHash.createHash((Query)bodyQueryWithoutSlice);
        String queryHash = hash.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Query w/o slice: " + String.valueOf(bodyQueryWithoutSlice));
            logger.debug("Query hash: " + String.valueOf(hash) + " " + String.valueOf(requestRange));
        }
        List resultVars = query.getProjectVars();
        try {
            PathStr queryHashPath = PathStr.parse((String)queryHash);
            String datasetHashStr = QueryHash.str((HashCode)this.datasetHash);
            org.aksw.commons.path.core.Path fullPath = PathStr.newRelativePath((String)datasetHashStr).resolve((org.aksw.commons.path.core.Path)queryHashPath);
            frontend = (ListPaginator)this.queryToCache.get((Object)fullPath, () -> {
                ListPaginatorSparql backend = new ListPaginatorSparql(bodyQueryWithoutSlice, q -> this.getDelegate().query(q));
                SliceWithPagesSyncToDisk sliceBuffer = SliceWithPagesSyncToDisk.create(this.arrayOps, (ObjectStore)this.objectStore, (org.aksw.commons.path.core.Path)fullPath, (int)this.cacheConfig.getPageSize(), (Duration)this.cacheConfig.getTerminationDelay());
                AdvancedRangeCacheImpl.Builder cacheBuilder = AdvancedRangeCacheImpl.newBuilder().setWorkerBulkSize(128).setSlice((Slice)sliceBuffer).setRequestLimit(this.cacheConfig.getMaxRequestSize()).setTerminationDelay(this.cacheConfig.getTerminationDelay());
                ListPaginatorWithAdvancedCache r = ListPaginatorWithAdvancedCache.create((ListPaginator)backend, (AdvancedRangeCacheImpl.Builder)cacheBuilder);
                if (logger.isDebugEnabled()) {
                    logger.debug("Is cache complete? " + r.getCore().getSlice().isComplete());
                }
                return r;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ListPaginator tmp = frontend.map(b -> BindingUtils.project((Binding)b, (Iterable)resultVars));
        Flowable flowable = (Flowable)tmp.apply((Object)requestRange);
        ResultSetRxImpl rs = ResultSetRxImpl.create((Query)query, (List)resultVars, (Flowable)flowable);
        QueryExec result = QueryExecWrapperTxn.wrap((QueryExec)rs.asQueryExec(), (Transactional)this.transactional);
        return result;
    }

    public UpdateExec createUpdateExec(final LinkSparqlUpdate baseLink, final UpdateExecBuilderCustomBase<?> builder) {
        UpdateExec core = new UpdateExec(){

            public void execute() {
                UpdateExecBuilder baseUpdateExecBuilder = baseLink.newUpdate();
                builder.applySettings(baseUpdateExecBuilder);
                UpdateRequest updateRequest = builder.getParsedUpdateRequest();
                String urStr = updateRequest.toString();
                baseUpdateExecBuilder.execute();
                HashCode hashCode = stmtHashFn.hashString((CharSequence)urStr, StandardCharsets.UTF_8);
                HashCode newDatasetHash = Hashing.combineOrdered(Arrays.asList(RDFLinkSourceWithRangeCache.this.datasetHash, hashCode));
                if (logger.isInfoEnabled()) {
                    logger.info("New dataset id after update: " + QueryHash.str((HashCode)newDatasetHash));
                }
                RDFLinkSourceWithRangeCache.this.datasetHash = newDatasetHash;
            }
        };
        UpdateExec result = UpdateExecWrapperTxn.wrap((UpdateProcessor)core, (Transactional)this.transactional);
        return result;
    }

    public static RDFLinkSourceWithRangeCache create(RDFLinkSource linkSource, Path cacheFolder, HashCode datasetHash, int maxCachedQueries, AdvancedRangeCacheConfig cacheConfig) {
        KryoPool kryoPool = KryoUtils.createKryoPool(JenaKryoRegistratorLib::registerClasses);
        ObjectStore objectStore = ObjectStoreImpl.create((Path)cacheFolder, (ObjectSerializer)ObjectSerializerKryo.create((KryoPool)kryoPool));
        RDFLinkSourceWithRangeCache result = new RDFLinkSourceWithRangeCache(linkSource, objectStore, datasetHash, maxCachedQueries, cacheConfig);
        return result;
    }

    public static RDFLinkSourceWithRangeCache create(RDFLinkSource linkSource, Path cacheFolder, long maxRequestSize) {
        HashCode hashCode = stmtHashFn.hashInt(0);
        return RDFLinkSourceWithRangeCache.create(linkSource, cacheFolder, maxRequestSize, hashCode);
    }

    public static RDFLinkSourceWithRangeCache create(RDFLinkSource linkSource, Path cacheFolder, long maxRequestSize, HashCode datasetHash) {
        AdvancedRangeCacheConfigImpl arcc = AdvancedRangeCacheConfigImpl.newDefaultsForObjects((long)maxRequestSize);
        RDFLinkSourceWithRangeCache result = RDFLinkSourceWithRangeCache.create(linkSource, cacheFolder, datasetHash, 1024, (AdvancedRangeCacheConfig)arcc);
        return result;
    }

    public static RDFLinkSourceWithRangeCache create(RDFLinkSourceWithRangeCache dataSource, Path cacheDir, long maxRequestSize) {
        return RDFLinkSourceWithRangeCache.create(dataSource, cacheDir, maxRequestSize);
    }
}

