/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import org.aksw.commons.rx.op.FlowableOperatorCollapseRuns;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.aksw.jena_sparql_api.lookup.MapPaginatorSparqlQueryBase;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPaginatorSparqlQuery
extends MapPaginatorSparqlQueryBase<Node, Table> {
    private static final Logger logger = LoggerFactory.getLogger(MapPaginatorSparqlQuery.class);
    protected Query attrQuery;
    protected Var attrVar;
    protected boolean forceSubQuery;

    public MapPaginatorSparqlQuery(QueryExecutionFactoryQuery qef, Fragment1 filterConcept, boolean isLeftJoin, Query attrQuery, Var attrVar, boolean forceSubQuery) {
        super(qef, filterConcept, isLeftJoin);
        this.attrQuery = attrQuery;
        this.attrVar = attrVar;
        this.forceSubQuery = forceSubQuery;
    }

    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        Fragment1 countConcept;
        if (this.filterConcept == null) {
            this.filterConcept = ConceptUtils.createSubjectConcept();
        }
        if (this.isLeftJoin) {
            Query query = ConceptUtils.createAttrQuery((Query)this.attrQuery, (Var)this.attrVar, (boolean)this.isLeftJoin, (Fragment1)this.filterConcept, (Long)itemLimit, null, (boolean)this.forceSubQuery);
            countConcept = new Concept(query.getQueryPattern(), this.attrVar);
        } else {
            Concept attrConcept = this.forceSubQuery ? new Concept((Element)new ElementSubQuery(this.attrQuery), this.attrVar) : new Concept(this.attrQuery.getQueryPattern(), this.attrVar);
            countConcept = ConceptUtils.createCombinedConcept((Fragment1)attrConcept, (Fragment1)this.filterConcept, (boolean)true, (boolean)false, (boolean)false);
        }
        Single result = SparqlRx.fetchCountQuery((QueryExecutionFactoryQuery)this.qef, (Query)countConcept.asQuery(), (Long)itemLimit, null);
        return result;
    }

    public Flowable<Map.Entry<Node, Table>> apply(Range<Long> range) {
        Query query;
        if (this.filterConcept != null && !this.attrVar.equals((Object)this.filterConcept.getVar())) {
            this.filterConcept = ConceptUtils.createRenamedConcept((Fragment1)this.filterConcept, (Var)this.attrVar);
        }
        Long limit = QueryUtils.rangeToLimit(range);
        Long offset = QueryUtils.rangeToOffset(range);
        if (this.filterConcept == null) {
            query = this.attrQuery.cloneQuery();
            QueryUtils.applySlice((Query)query, (Long)offset, (Long)limit, (boolean)false);
        } else {
            query = ConceptUtils.createAttrQuery((Query)this.attrQuery, (Var)this.attrVar, (boolean)this.isLeftJoin, (Fragment1)this.filterConcept, (Long)limit, (Long)offset, (boolean)this.forceSubQuery);
        }
        SortCondition sc = new SortCondition((Expr)new ExprVar(this.attrVar), 1);
        if (query.getOrderBy() == null) {
            query.addOrderBy(sc);
        } else {
            query.getOrderBy().add(0, sc);
        }
        logger.debug("Query: " + String.valueOf(query));
        Flowable result = SparqlRx.execSelectRaw((QueryExecutionFactoryQuery)this.qef, (Query)query).lift((FlowableOperator)FlowableOperatorCollapseRuns.create((CollapseRunsSpec)CollapseRunsSpec.create(b -> b.get(this.attrVar), groupKey -> new TableN(), Table::addBinding)));
        return result;
    }
}

