/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.cache.extra.CacheResourceCacheEntry;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.system.StreamRDFWriter;

public class CacheFrontendImpl
implements CacheFrontend {
    protected CacheBackend cacheBackend;
    protected RDFFormat rdfFormat;
    protected Lang resultSetLang;

    public CacheFrontendImpl(CacheBackend cacheBackend) {
        this(cacheBackend, RDFFormat.RDF_THRIFT, ResultSetLang.RS_Thrift);
    }

    public CacheFrontendImpl(CacheBackend cacheBackend, RDFFormat rdfFormat, Lang resultSetLang) {
        this.cacheBackend = cacheBackend;
        this.rdfFormat = rdfFormat;
        this.resultSetLang = resultSetLang;
    }

    @Override
    public void write(String service, String queryString, ResultSet resultSet) {
        try {
            this._write(service, queryString, resultSet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, ResultSet resultSet) throws IOException {
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        new Thread(() -> {
            try {
                ResultSetMgr.write((OutputStream)out, (ResultSet)resultSet, (Lang)this.resultSetLang);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, ResultSet resultSet) {
        this.write(service, query.toString(), resultSet);
    }

    @Override
    public void write(String service, String queryString, Model model) {
        try {
            this._write(service, queryString, model);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, final Model model) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            @Override
            public void run() {
                RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)CacheFrontendImpl.this.rdfFormat);
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheBackend.write(service, queryString, in);
    }

    public void _writeTriples(String service, String queryString, Iterator<Triple> it) throws IOException {
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        StreamRDF streamRdf = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)this.rdfFormat);
        new Thread(() -> {
            try {
                streamRdf.start();
                StreamRDFOps.sendTriplesToStream((Iterator)it, (StreamRDF)streamRdf);
                streamRdf.finish();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, Model model) {
        this.write(service, query.toString(), model);
    }

    @Override
    public CacheResource lookup(String service, String queryString) {
        CacheEntry cacheEntry = this.cacheBackend.lookup(service, queryString);
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry, this.rdfFormat.getLang(), this.resultSetLang);
    }

    @Override
    public CacheResource lookup(String service, Query query) {
        CacheEntry cacheEntry = this.cacheBackend.lookup(service, query.toString());
        return cacheEntry == null ? null : new CacheResourceCacheEntry(cacheEntry, this.rdfFormat.getLang(), this.resultSetLang);
    }

    @Override
    public void write(String service, String queryString, boolean value) {
        try {
            this._write(service, queryString, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void _write(String service, String queryString, boolean value) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(String.valueOf(value).getBytes());
        this.cacheBackend.write(service, queryString, in);
    }

    @Override
    public void write(String service, Query query, boolean value) {
        this.write(service, query.toString(), value);
    }

    @Override
    public boolean isReadOnly() {
        boolean result = this.cacheBackend.isReadOnly();
        return result;
    }

    @Override
    public void writeTriples(String service, String queryString, Iterator<Triple> it) {
        try {
            this._writeTriples(service, queryString, it);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeTriples(String service, Query query, Iterator<Triple> it) {
        this.writeTriples(service, query.toString(), it);
    }
}

