/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.core;

import java.io.IOException;
import java.util.Iterator;
import org.aksw.commons.util.closeable.AutoCloseables;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.NiceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCacheEx
extends QueryExecutionWrapperBase<QueryExecution> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCacheEx.class);
    private CacheFrontend cache;
    private String service;
    private String queryString;
    private CacheResource currentResource = null;

    public QueryExecutionCacheEx(QueryExecution decoratee, String service, String queryString, CacheFrontend cache) {
        super(decoratee);
        this.service = service;
        this.queryString = queryString;
        this.cache = cache;
    }

    public static boolean needsCaching(CacheResource resource) {
        boolean result;
        if (resource == null) {
            result = true;
        } else if (resource.isOutdated()) {
            try {
                resource.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public synchronized ResultSet doCacheResultSet() {
        ResultSet result = null;
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            ResultSet rs = this.getDelegate().execSelect();
            if (this.cache.isReadOnly()) {
                result = rs;
            } else {
                try {
                    logger.trace("Cache write [" + this.service + "]: " + this.queryString);
                    this.cache.write(this.service, this.queryString, rs);
                }
                catch (Exception e) {
                    try {
                        this.getDelegate().abort();
                    }
                    catch (Exception x) {
                        logger.warn("Error", (Throwable)x);
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    this.getDelegate().close();
                }
                resource = this.cache.lookup(this.service, this.queryString);
                if (resource == null) {
                    throw new RuntimeException("Cache error: Lookup of just written data failed");
                }
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        if (result == null) {
            this.currentResource = resource;
            result = resource.asResultSet();
        }
        return result;
    }

    public synchronized Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Iterator<Triple> doCacheTriples() {
        try {
            return this._doCacheTriples();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Iterator<Triple> _doCacheTriples() throws IOException {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            Iterator it = this.getDelegate().execConstructTriples();
            try {
                this.cache.writeTriples(this.service, this.queryString, (Iterator<Triple>)it);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                NiceIterator.close((Iterator)it);
                this.getDelegate().close();
            }
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return resource.asIteratorTriples();
    }

    public synchronized Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            Model model;
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cache.write(this.service, this.queryString, model);
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return resource.asModel(result);
    }

    public synchronized boolean doCacheBoolean() {
        CacheResource resource = this.cache.lookup(this.service, this.queryString);
        if (QueryExecutionCacheEx.needsCaching(resource)) {
            boolean ret;
            try {
                ret = this.getDelegate().execAsk();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cache.write(this.service, this.queryString, ret);
            resource = this.cache.lookup(this.service, this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return resource.asBoolean();
    }

    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheEx.this.getDelegate().execConstruct();
            }
        });
    }

    public Iterator<Triple> execConstructTriples() {
        return this.doCacheTriples();
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheEx.this.getDelegate().execDescribe();
            }
        });
    }

    public boolean execAsk() {
        return this.doCacheBoolean();
    }

    public void close() {
        QueryExecution dec;
        if (this.currentResource != null) {
            AutoCloseables.close((AutoCloseable)this.currentResource);
        }
        if ((dec = this.getDelegate()) != null) {
            dec.close();
        }
    }
}

